namespace gov.va.med.vbecs.Common 
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Hines OIFO</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>11/2/2011</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///    VbecsTables class - used to get table name and all the columns names
	///
	///    The content in this file was generated by UpdateDBSchemaConsts macro.
	///    Please do not modify the file manually since it should only contain 
	///    throw-away code which can be re-created by the macro.
	///
    ///    Last time generated by DNS      \DNS   lohseg at 1:17:21 PM, Wednesday, May 6, 2015
	///
	///    WARNING: re-generate the file every time the database schema changes!
	///</summary>

	#endregion

	public abstract class VbecsTables
	{
		/// <summary>
		/// Address class
		/// </summary>
		public abstract class Address
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "Address",
				AddressCity = "AddressCity",
				AddressGuid = "AddressGuid",
				AddressLine1 = "AddressLine1",
				AddressLine2 = "AddressLine2",
				AddressLine3 = "AddressLine3",
				AddressZipCode = "AddressZipCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				StateCode = "StateCode";
		}

		/// <summary>
		/// AntibodyAntigen class
		/// </summary>
		public abstract class AntibodyAntigen
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "AntibodyAntigen",
				AntibodyTypeId = "AntibodyTypeId",
				AntigenTypeId = "AntigenTypeId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// AntibodyParameter class
		/// </summary>
		public abstract class AntibodyParameter
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "AntibodyParameter",
				AntibodyParameterGuid = "AntibodyParameterGuid",
				AntibodyTypeId = "AntibodyTypeId",
				CanChangeIndicator = "CanChangeIndicator",
				CompatibilityPercentage = "CompatibilityPercentage",
				DivisionCode = "DivisionCode",
				HigherLevelOverrideIndicator = "HigherLevelOverrideIndicator",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// AntibodyScreenDisplay class
		/// </summary>
		public abstract class AntibodyScreenDisplay
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "AntibodyScreenDisplay",
				AntibodyScreenDisplayCode = "AntibodyScreenDisplayCode",
				AntibodyScreenDisplayText = "AntibodyScreenDisplayText",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// AntibodyType class
		/// </summary>
		public abstract class AntibodyType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "AntibodyType",
				AntibodyReferenceCode = "AntibodyReferenceCode",
				AntibodyTypeId = "AntibodyTypeId",
				AntibodyTypeName = "AntibodyTypeName",
				ClinicallySignificantIndicator = "ClinicallySignificantIndicator",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// AntigenTest class
		/// </summary>
		public abstract class AntigenTest
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "AntigenTest",
				AntigenTestId = "AntigenTestId",
				AntigenTypeId = "AntigenTypeId",
				BloodTestTypeId = "BloodTestTypeId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// AntigenType class
		/// </summary>
		public abstract class AntigenType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "AntigenType",
				AntigenTypeId = "AntigenTypeId",
				AntigenTypeName = "AntigenTypeName",
				BceSortColumn = "BceSortColumn",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// AntiseraOrderedTest class
		/// </summary>
		public abstract class AntiseraOrderedTest
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "AntiseraOrderedTest",
				AntiseraOrderedTestGuid = "AntiseraOrderedTestGuid",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OrderedTestGuid = "OrderedTestGuid",
				RackLotGuid = "RackLotGuid",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// AntiseraUnitTest class
		/// </summary>
		public abstract class AntiseraUnitTest
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "AntiseraUnitTest",
				AntiseraUnitTestGuid = "AntiseraUnitTestGuid",
				AntiseraWorklistTypingGuid = "AntiseraWorklistTypingGuid",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RackLotGuid = "RackLotGuid",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// AntiseraWorklist class
		/// </summary>
		public abstract class AntiseraWorklist
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "AntiseraWorklist",
				AntiseraWorklistGuid = "AntiseraWorklistGuid",
				AutoInstrumentName = "AutoInstrumentName",
				DivisionCode = "DivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				TaskStatusCode = "TaskStatusCode",
				TestingMethodCode = "TestingMethodCode",
				WorklistCreateDate = "WorklistCreateDate",
				WorklistName = "WorklistName";
		}

		/// <summary>
		/// AntiseraWorklistTyping class
		/// </summary>
		public abstract class AntiseraWorklistTyping
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "AntiseraWorklistTyping",
				AntiseraWorklistGuid = "AntiseraWorklistGuid",
				AntiseraWorklistTypingGuid = "AntiseraWorklistTypingGuid",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OrderableTestId = "OrderableTestId",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// ApplicationOfRecord class
		/// </summary>
		public abstract class ApplicationOfRecord
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ApplicationOfRecord",
				ApplicationName = "ApplicationName",
				ApplicationOfRecordId = "ApplicationOfRecordId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// AssociatedInstitution class
		/// </summary>
		public abstract class AssociatedInstitution
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "AssociatedInstitution",
				AssociatedInstitutionGuid = "AssociatedInstitutionGuid",
				DivisionCode = "DivisionCode",
				InstitutionDivisionCode = "InstitutionDivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// BceStatus class
		/// </summary>
		public abstract class BceStatus
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "BceStatus",
				BceStatusCode = "BceStatusCode",
				BceStatusText = "BceStatusText",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// BloodProduct class
		/// </summary>
		public abstract class BloodProduct
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "BloodProduct",
				BloodProductGuid = "BloodProductGuid",
				CrossmatchRequiredIndicator = "CrossmatchRequiredIndicator",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MaximumStorageTime = "MaximumStorageTime",
				OriginalProductTypeCode = "OriginalProductTypeCode",
				ProductAttributeForm = "ProductAttributeForm",
				ProductCode = "ProductCode",
				ProductCodeIndicator = "ProductCodeIndicator",
				ProductModificationIndicator = "ProductModificationIndicator",
				ProductName = "ProductName",
				ProductShortName = "ProductShortName",
				ProductTypeCode = "ProductTypeCode",
				ProductVolume = "ProductVolume",
				RecordStatusCode = "RecordStatusCode",
				RetireDate = "RetireDate",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// BloodProductModification class
		/// </summary>
		public abstract class BloodProductModification
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "BloodProductModification",
				BloodProductModificationGuid = "BloodProductModificationGuid",
				ExpirationDateRule = "ExpirationDateRule",
				FromBloodProductGuid = "FromBloodProductGuid",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MethodSelect = "MethodSelect",
				ProductModificationCode = "ProductModificationCode",
				RowVersion = "RowVersion",
				ToBloodProductGuid = "ToBloodProductGuid";
		}

		/// <summary>
		/// BloodTestType class
		/// </summary>
		public abstract class BloodTestType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "BloodTestType",
				BloodTestName = "BloodTestName",
				BloodTestTypeId = "BloodTestTypeId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OrderableTestId = "OrderableTestId",
				Phase = "Phase",
				ReportableTestId = "ReportableTestId",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				TestedWith = "TestedWith";
		}

		/// <summary>
		/// BloodType class
		/// </summary>
		public abstract class BloodType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "BloodType",
				BloodTypeCode = "BloodTypeCode",
				BloodTypeText = "BloodTypeText",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// BloodUnit class
		/// </summary>
		public abstract class BloodUnit
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "BloodUnit",
				BloodProductGuid = "BloodProductGuid",
				BloodUnitGuid = "BloodUnitGuid",
				DiscardedPlasmaVolume = "DiscardedPlasmaVolume",
				DivisionCode = "DivisionCode",
				DonationTypeId = "DonationTypeId",
				EntryMethodCode = "EntryMethodCode",
				EyeReadableUnitId = "EyeReadableUnitId",
				LabelTypeCode = "LabelTypeCode",
				LabelUnitId = "LabelUnitId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OriginalVolume = "OriginalVolume",
				ProcessingTechId = "ProcessingTechId",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				UnitContainerLotNumber = "UnitContainerLotNumber",
				UnitDivisionId = "UnitDivisionId",
				UnitFdaRegistrationNumber = "UnitFdaRegistrationNumber",
				UnitInDate = "UnitInDate",
				UnitProductCode = "UnitProductCode";
		}

		/// <summary>
		/// BloodUnitAntigen class
		/// </summary>
		public abstract class BloodUnitAntigen
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "BloodUnitAntigen",
				AntigenTypeId = "AntigenTypeId",
				BloodUnitGuid = "BloodUnitGuid",
				Comments = "Comments",
				DivisionCode = "DivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				Positive = "Positive",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// BloodUnitCurrentShipment class
		/// </summary>
		public abstract class BloodUnitCurrentShipment
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "BloodUnitCurrentShipment",
				BloodUnitCurrentShipmentGuid = "BloodUnitCurrentShipmentGuid",
				BloodUnitGuid = "BloodUnitGuid",
				IncomingShipmentGuid = "IncomingShipmentGuid",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OutgoingShipmentGuid = "OutgoingShipmentGuid",
				Rowversion = "Rowversion";
		}

		/// <summary>
		/// BloodUnitFinance class
		/// </summary>
		public abstract class BloodUnitFinance
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "BloodUnitFinance",
				BloodUnitFinanceGuid = "BloodUnitFinanceGuid",
				BloodUnitGuid = "BloodUnitGuid",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				ReturnCreditAmount = "ReturnCreditAmount",
				RowVersion = "RowVersion",
				SpecialTestingCost = "SpecialTestingCost",
				UnitCost = "UnitCost";
		}

		/// <summary>
		/// BloodUnitMedia class
		/// </summary>
		public abstract class BloodUnitMedia
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "BloodUnitMedia",
				BloodTypeCode = "BloodTypeCode",
				BloodUnitGuid = "BloodUnitGuid",
				BloodUnitMediaGuid = "BloodUnitMediaGuid",
				Comments = "Comments",
				DirectedPatientGuid = "DirectedPatientGuid",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RemoveRestrictionDate = "RemoveRestrictionDate",
				RemoveRestrictionTechId = "RemoveRestrictionTechId",
				RhFactorCode = "RhFactorCode",
				RowVersion = "RowVersion",
				TestingStatusId = "TestingStatusId",
				UnitExpirationDate = "UnitExpirationDate";
		}

		/// <summary>
		/// BloodUnitModification class
		/// </summary>
		public abstract class BloodUnitModification
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "BloodUnitModification",
				BloodUnitModificationGuid = "BloodUnitModificationGuid",
				Comments = "Comments",
				DivisionCode = "DivisionCode",
				FromBloodProductGuid = "FromBloodProductGuid",
				FromBloodUnitGuid = "FromBloodUnitGuid",
				FromOriginalVolume = "FromOriginalVolume",
				FromProductShipperGuid = "FromProductShipperGuid",
				FromUnitExpirationDate = "FromUnitExpirationDate",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				ModificationCost = "ModificationCost",
				ModificationDate = "ModificationDate",
				ModificationMethodCode = "ModificationMethodCode",
				ModificationTechId = "ModificationTechId",
				NewContainerWeldIndicator = "NewContainerWeldIndicator",
				NewLabelVerificationDatetime = "NewLabelVerificationDatetime",
				OriginalUnitIndicator = "OriginalUnitIndicator",
				PoolEditedIndicator = "PoolEditedIndicator",
				ProductModificationCode = "ProductModificationCode",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				ToBloodUnitGuid = "ToBloodUnitGuid";
		}

		/// <summary>
		/// BloodUnitShipment class
		/// </summary>
		public abstract class BloodUnitShipment
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "BloodUnitShipment",
				BloodUnitGuid = "BloodUnitGuid",
				BloodUnitShipmentGuid = "BloodUnitShipmentGuid",
				IncomingShipmentGuid = "IncomingShipmentGuid",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				LoginBloodProductGuid = "LoginBloodProductGuid",
				LoginFullProductCode = "LoginFullProductCode",
				LoginValues = "LoginValues",
				OutgoingShipmentGuid = "OutgoingShipmentGuid",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// BloodUnitStatus class
		/// </summary>
		public abstract class BloodUnitStatus
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "BloodUnitStatus",
				BiohazardousWarningIndicator = "BiohazardousWarningIndicator",
				BloodUnitGuid = "BloodUnitGUID",
				BloodUnitStatusGuid = "BloodUnitStatusGuid",
				DiscardCannedCommentGuid = "DiscardCannedCommentGuid",
				EmergencyIssueIndicator = "EmergencyIssueIndicator",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				PresumedTransfusedIndicator = "PresumedTransfusedIndicator",
				QuarantineCannedCommentGuid = "QuarantineCannedCommentGuid",
				QuarantineIndicator = "QuarantineIndicator",
				RowVersion = "RowVersion",
				TestingLimitIndicator = "TestingLimitIndicator",
				UnitStatusComments = "UnitStatusComments",
				UnitStatusDate = "UnitStatusDate";
		}

		/// <summary>
		/// BloodUnitStatusCodeCurrent class
		/// </summary>
		public abstract class BloodUnitStatusCodeCurrent
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "BloodUnitStatusCodeCurrent",
				BloodUnitGuid = "BloodUnitGuid",
				BloodUnitStatusCodeCurrentGuid = "BloodUnitStatusCodeCurrentGuid",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				UnitStatusCode = "UnitStatusCode";
		}

		/// <summary>
		/// BloodUnitTest class
		/// </summary>
		public abstract class BloodUnitTest
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "BloodUnitTest",
				AntiseraWorklistTypingGuid = "AntiseraWorklistTypingGuid",
				AutoInstrumentName = "AutoInstrumentName",
				BloodTestTypeId = "BloodTestTypeId",
				BloodUnitGuid = "BloodUnitGuid",
				BloodUnitTestGuid = "BloodUnitTestGuid",
				ConfirmationWorklistUnitGuid = "ConfirmationWorklistUnitGuid",
				CorrectedResultIndicator = "CorrectedResultIndicator",
				DivisionCode = "DivisionCode",
				EntryMethodCode = "EntryMethodCode",
				EntryTechId = "EntryTechId",
				InactivateDate = "InactivateDate",
				InactivateUser = "InactivateUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OrderedComponentGuid = "OrderedComponentGuid",
				OrderedTestGuid = "OrderedTestGuid",
				OrderedUnitGuid = "OrderedUnitGuid",
				PatientTransfusionReactionGuid = "PatientTransfusionReactionGuid",
				RackGuid = "RackGuid",
				ReactivityPhaseCode = "ReactivityPhaseCode",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				TestComments = "TestComments",
				TestDate = "TestDate",
				TestingMethodCode = "TestingMethodCode",
				TestResultId = "TestResultId",
				TestTechId = "TestTechId";
		}

		/// <summary>
		/// BrokenRule class
		/// </summary>
		public abstract class BrokenRule
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "BrokenRule",
				FieldName = "FieldName",
				FormName = "FormName",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				ValidationMessage = "ValidationMessage";
		}

		/// <summary>
		/// BrokenRuleSet class
		/// </summary>
		public abstract class BrokenRuleSet
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "BrokenRuleSet",
				FieldName = "FieldName",
				FormName = "FormName",
				IsInitiallyBroken = "IsInitiallyBroken",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				RuleSet = "RuleSet";
		}

		/// <summary>
		/// CannedComment class
		/// </summary>
		public abstract class CannedComment
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "CannedComment",
				CannedCommentCategoryCode = "CannedCommentCategoryCode",
				CannedCommentGuid = "CannedCommentGuid",
				CannedCommentText = "CannedCommentText",
				DivisionCode = "DivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// CannedCommentCategory class
		/// </summary>
		public abstract class CannedCommentCategory
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "CannedCommentCategory",
				CannedCommentCategoryCode = "CannedCommentCategoryCode",
				CannedCommentCategoryText = "CannedCommentCategoryText",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				LockingGuid = "LockingGuid",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// Compatibility class
		/// </summary>
		public abstract class Compatibility
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "Compatibility",
				CompatibilityId = "CompatibilityId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OverrideRequired = "OverrideRequired",
				PatientAboRh = "PatientAboRh",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				UnitAboRh = "UnitAboRh";
		}

		/// <summary>
		/// ComponentClass class
		/// </summary>
		public abstract class ComponentClass
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ComponentClass",
				ComponentClassId = "ComponentClassId",
				ComponentClassName = "ComponentClassName",
				ComponentClassShortName = "ComponentClassShortName",
				CprsOrderableItemId = "CprsOrderableItemId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// ComponentClassCompatibility class
		/// </summary>
		public abstract class ComponentClassCompatibility
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ComponentClassCompatibility",
				CompatibilityId = "CompatibilityId",
				ComponentClassId = "ComponentClassId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// ComponentClassParameter class
		/// </summary>
		public abstract class ComponentClassParameter
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ComponentClassParameter",
				ComponentClassId = "ComponentClassId",
				ComponentClassParameterGuid = "ComponentClassParameterGuid",
				DivisionCode = "DivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MaximumTransfusionTime = "MaximumTransfusionTime",
				OrderableIndicator = "OrderableIndicator",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				SpecimenRequiredIndicator = "SpecimenRequiredIndicator";
		}

		/// <summary>
		/// ComponentRequirement class
		/// </summary>
		public abstract class ComponentRequirement
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ComponentRequirement",
				BceSortColumn = "BceSortColumn",
				ComponentRequirementAbbreviation = "ComponentRequirementAbbreviation",
				ComponentRequirementId = "ComponentRequirementId",
				ComponentRequirementText = "ComponentRequirementText",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// ConfirmationWorklistUnit class
		/// </summary>
		public abstract class ConfirmationWorklistUnit
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ConfirmationWorklistUnit",
				AutoInstrumentName = "AutoInstrumentName",
				AutoInstrumentQcIndicator = "AutoInstrumentQcIndicator",
				BloodUnitGuid = "BloodUnitGuid",
				ConfirmationWorklistUnitGuid = "ConfirmationWorklistUnitGuid",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RackGuid = "RackGuid",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// CptCache class
		/// </summary>
		public abstract class CptCache
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "CptCache",
				Code_Id = "Code_Id",
				CPTCode_Text = "CPTCode_Text",
				LastUpdateDate = "LastUpdateDate";
		}

		/// <summary>
		/// CrossmatchResult class
		/// </summary>
		public abstract class CrossmatchResult
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "CrossmatchResult",
				CrossmatchResultCode = "CrossmatchResultCode",
				CrossmatchResultText = "CrossmatchResultText",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// DailyControl class
		/// </summary>
		public abstract class DailyControl
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "DailyControl",
				Comments = "Comments",
				CommercialTemplateIndicator = "CommercialTemplateIndicator",
				DailyAlertTime = "DailyAlertTime",
				DailyControlGuid = "DailyControlGuid",
				DivisionCode = "DivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				NumberOfRacks = "NumberOfRacks",
				PrimaryEnhancementMediaId = "PrimaryEnhancementMediaId",
				RackNamesIndicator = "RackNamesIndicator",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				SecondaryEnhancementMediaId = "SecondaryEnhancementMediaId";
		}

		/// <summary>
		/// DailyQcWorklist class
		/// </summary>
		public abstract class DailyQcWorklist
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "DailyQcWorklist",
				DailyQcExpirationDate = "DailyQcExpirationDate",
				DailyQcWorklistGuid = "DailyQcWorklistGuid",
				DailyUseIndicator = "DailyUseIndicator",
				DivisionCode = "DivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				PartiallyTestedIndicator = "PartiallyTestedIndicator",
				QCOfflineIndicator = "QCOfflineIndicator",
				RackGuid = "RackGuid",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// DaylightSavingsType  class
		/// </summary>
		public abstract class DaylightSavingsType 
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "DaylightSavingsType ",
				DaylightSavingsTypeId = "DaylightSavingsTypeId",
				DaylightSavingsTypeText = "DaylightSavingsTypeText",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// DonationType class
		/// </summary>
		public abstract class DonationType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "DonationType",
				DonationTypeCode = "DonationTypeCode",
				DonationTypeId = "DonationTypeId",
				DonationTypeText = "DonationTypeText",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RestrictionTypeCode = "RestrictionTypeCode",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// dtproperties class
		/// </summary>
		public abstract class dtproperties
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "dtproperties",
				id = "id",
				lvalue = "lvalue",
				objectid = "objectid",
				property = "property",
				uvalue = "uvalue",
				value = "value",
				version = "version";
		}

		/// <summary>
		/// EnhancementMedia class
		/// </summary>
		public abstract class EnhancementMedia
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "EnhancementMedia",
				EnhancementMediaId = "EnhancementMediaId",
				EnhancementMediaName = "EnhancementMediaName",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				ReagentTypeId = "ReagentTypeId",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// EntryMethod class
		/// </summary>
		public abstract class EntryMethod
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "EntryMethod",
				EntryMethodCode = "EntryMethodCode",
				EntryMethodText = "EntryMethodText",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// Equipment class
		/// </summary>
		public abstract class Equipment
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "Equipment",
				AddressGuid = "AddressGuid",
				Comments = "Comments",
				DivisionCode = "DivisionCode",
				EquipmentGuid = "EquipmentGuid",
				EquipmentName = "EquipmentName",
				EquipmentType = "EquipmentType",
				InspectionIndicator = "InspectionIndicator",
				InvoiceNumber = "InvoiceNumber",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				LocalIdentifier = "LocalIdentifier",
				MaintenanceContractDate = "MaintenanceContractDate",
				MaintenanceContractNumber = "MaintenanceContractNumber",
				ManufacturerName = "ManufacturerName",
				ManufacturerPhoneNumber = "ManufacturerPhoneNumber",
				NextMaintenanceText = "NextMaintenanceText",
				OutOfServiceIndicator = "OutOfServiceIndicator",
				ReceiptDate = "ReceiptDate",
				ReceiptTechId = "ReceiptTechId",
				RowVersion = "RowVersion",
				SerialNumber = "SerialNumber";
		}

		/// <summary>
		/// EquipmentMaintenance class
		/// </summary>
		public abstract class EquipmentMaintenance
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "EquipmentMaintenance",
				EquipmentGuid = "EquipmentGuid",
				EquipmentMaintenanceGuid = "EquipmentMaintenanceGuid",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MaintenanceDate = "MaintenanceDate",
				MaintenanceResults = "MaintenanceResults",
				MaintenanceType = "MaintenanceType",
				PendingIssues = "PendingIssues",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// ExceptionAntigenTest class
		/// </summary>
		public abstract class ExceptionAntigenTest
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionAntigenTest",
				CurrentTestingTechName = "CurrentTestingTechName",
				DivisionCode = "DivisionCode",
				ExceptionAntigenTestGuid = "ExceptionAntigenTestGuid",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				InvalidatedDate = "InvalidatedDate",
				InvalidatedResult = "InvalidatedResult",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				PreviousTestingTechName = "PreviousTestingTechName",
				ProductShortName = "ProductShortName",
				TestPerformed = "TestPerformed",
				UnitGuid = "UnitGuid",
				UnitId = "UnitId";
		}

		/// <summary>
		/// ExceptionCautionTag class
		/// </summary>
		public abstract class ExceptionCautionTag
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionCautionTag",
				DivisionCode = "DivisionCode",
				ExceptionCautionTagGuid = "ExceptionCautionTagGuid",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				PatientAboRh = "PatientAboRh",
				PatientGuid = "PatientGuid",
				PatientId = "PatientId",
				PatientName = "PatientName",
				ProductCode = "ProductCode",
				SpecimenUid = "SpecimenUid",
				UnitAboRh = "UnitAboRh",
				UnitExpirationDate = "UnitExpirationDate",
				UnitGuid = "UnitGuid",
				UnitId = "UnitId";
		}

		/// <summary>
		/// ExceptionElectronicTransfusion class
		/// </summary>
		public abstract class ExceptionElectronicTransfusion
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionElectronicTransfusion",
				BedsideVerificationDate = "BedsideVerificationDate",
				BedsideVerificationUnitManualEntryReason = "BedsideVerificationUnitManualEntryReason",
				DivisionCode = "DivisionCode",
				ExceptionDate = "ExceptionDate",
				ExceptionElectronicTransfusionGuid = "ExceptionElectronicTransfusionGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				InterruptionIndicator = "InterruptionIndicator",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				PatientId = "PatientId",
				PatientName = "PatientName",
				PatientTransfusionComment = "PatientTransfusionComment",
				PatientTransfusionGuid = "PatientTransfusionGuid",
				ReactionIndicator = "ReactionIndicator",
				ReactionSymptoms = "ReactionSymptoms",
				TransfusedVolume = "TransfusedVolume",
				TransfusionEndDateTime = "TransfusionEndDateTime",
				Transfusionist1Id = "Transfusionist1Id",
				Transfusionist2Id = "Transfusionist2Id",
				TransfusionLocation = "TransfusionLocation",
				TransfusionStartDateTime = "TransfusionStartDateTime",
				UnitId = "UnitId",
				UnitProductCode = "UnitProductCode";
		}

		/// <summary>
		/// ExceptionEmergencyIssueOrder class
		/// </summary>
		public abstract class ExceptionEmergencyIssueOrder
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionEmergencyIssueOrder",
				ComponentClassOrdered = "ComponentClassOrdered",
				CprsOrderNumber = "CprsOrderNumber",
				DateAcknowledged = "DateAcknowledged",
				DateWanted = "DateWanted",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionEmergencyIssueOrderGuid = "ExceptionEmergencyIssueOrderGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				PatientGuid = "PatientGuid",
				PatientId = "PatientId",
				PatientName = "PatientName",
				ProcessingTechName = "ProcessingTechName",
				UrgencyIndicator = "UrgencyIndicator";
		}

		/// <summary>
		/// ExceptionEmergencyIssueUnitTest class
		/// </summary>
		public abstract class ExceptionEmergencyIssueUnitTest
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionEmergencyIssueUnitTest",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionEmergencyIssueUnitTestGuid = "ExceptionEmergencyIssueUnitTestGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				PatientAboRh = "PatientAboRh",
				PatientGuid = "PatientGuid",
				PatientId = "PatientId",
				PatientName = "PatientName",
				TestingTechName = "TestingTechName",
				TestInterp = "TestInterp",
				TestPerformed = "TestPerformed",
				UnitAboRh = "UnitAboRh",
				UnitExpirationDate = "UnitExpirationDate",
				UnitGuid = "UnitGuid",
				UnitId = "UnitId",
				UnitProductType = "UnitProductType";
		}

		/// <summary>
		/// ExceptionExpiredTask class
		/// </summary>
		public abstract class ExceptionExpiredTask
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionExpiredTask",
				ComponentClassOrdered = "ComponentClassOrdered",
				CprsOrderNumber = "CprsOrderNumber",
				DateWanted = "DateWanted",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionExpiredTaskGuid = "ExceptionExpiredTaskGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				LoginTechName = "LoginTechName",
				PatientId = "PatientId",
				PatientName = "PatientName",
				Quantity = "Quantity",
				SpecimenUid = "SpecimenUid";
		}

		/// <summary>
		/// ExceptionExpiredUnitReceived class
		/// </summary>
		public abstract class ExceptionExpiredUnitReceived
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionExpiredUnitReceived",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionExpiredUnitReceivedGuid = "ExceptionExpiredUnitReceivedGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				ExpirationDate = "ExpirationDate",
				IncomingShipmentDate = "IncomingShipmentDate",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				ProcessingTechId = "ProcessingTechId",
				ProductCode = "ProductCode",
				ProductType = "ProductType",
				UnitAboRh = "UnitAboRh",
				UnitGuid = "UnitGuid",
				UnitId = "UnitId";
		}

		/// <summary>
		/// ExceptionInconclusiveCrossmatch class
		/// </summary>
		public abstract class ExceptionInconclusiveCrossmatch
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionInconclusiveCrossmatch",
				BloodUnitGuid = "BloodUnitGuid",
				BloodUnitId = "BloodUnitId",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionInconclusiveCrossmatchGuid = "ExceptionInconclusiveCrossmatchGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				PatientGuid = "PatientGuid",
				PatientId = "PatientId",
				PatientName = "PatientName",
				SpecimenUid = "SpecimenUid",
				SystemInterp = "SystemInterp",
				TechInterp = "TechInterp",
				TestingTechName = "TestingTechName",
				UnitProductCode = "UnitProductCode";
		}

		/// <summary>
		/// ExceptionLabelMismatch class
		/// </summary>
		public abstract class ExceptionLabelMismatch
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionLabelMismatch",
				CorrectedValue = "CorrectedValue",
				DiscrepantField = "DiscrepantField",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionLabelMismatchGuid = "ExceptionLabelMismatchGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				ModificationDate = "ModificationDate",
				ModificationType = "ModificationType",
				TargetProductCode = "TargetProductCode",
				TargetProductType = "TargetProductType",
				TargetUnitAboRh = "TargetUnitABORh",
				TargetUnitExpirationDate = "TargetUnitExpirationDate",
				TargetUnitGuid = "TargetUnitGuid",
				TargetUnitId = "TargetUnitId",
				TestingTechName = "TestingTechName";
		}

		/// <summary>
		/// ExceptionPatientAboRh class
		/// </summary>
		public abstract class ExceptionPatientAboRh
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionPatientAboRh",
				CurrentSystemAboRh = "CurrentSystemAboRh",
				CurrentTechAboRh = "CurrentTechAboRh",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionPatientAboRhGuid = "ExceptionPatientAboRhGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				PatientGuid = "PatientGuid",
				PatientId = "PatientId",
				PatientName = "PatientName",
				PreTestingAboRh = "PreTestingAboRh",
				SpecimenUid = "SpecimenUid",
				TestDate = "TestDate",
				TestingTechName = "TestingTechName";
		}

		/// <summary>
		/// ExceptionPatientAboRhDiscrepancy class
		/// </summary>
		public abstract class ExceptionPatientAboRhDiscrepancy
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionPatientAboRhDiscrepancy",
				CurrentEntryTechName = "CurrentEntryTechName",
				CurrentSpecimenAboRh = "CurrentSpecimenAboRh",
				CurrentSpecimenUid = "CurrentSpecimenUid",
				CurrentTestingDate = "CurrentTestingDate",
				CurrentTestingDivision = "CurrentTestingDivision",
				CurrentTestingTechName = "CurrentTestingTechName",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionPatientAboRhDiscrepancyGuid = "ExceptionPatientAboRhDiscrepancyGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				PatientGuid = "PatientGuid",
				PatientId = "PatientId",
				PatientName = "PatientName",
				PreviousEntryTechName = "PreviousEntryTechName",
				PreviousSpecimenAboRh = "PreviousSpecimenAboRh",
				PreviousSpecimenUid = "PreviousSpecimenUid",
				PreviousTestingDate = "PreviousTestingDate",
				PreviousTestingDivision = "PreviousTestingDivision",
				PreviousTestingTechName = "PreviousTestingTechName";
		}

		/// <summary>
		/// ExceptionPatientAntigenDiscrepancy class
		/// </summary>
		public abstract class ExceptionPatientAntigenDiscrepancy
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionPatientAntigenDiscrepancy",
				CurrentSpecimenTestResults = "CurrentSpecimenTestResults",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionPatientAntigenDiscrepancyGuid = "ExceptionPatientAntigenDiscrepancyGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				HistoricSpecimenTestResults = "HistoricSpecimenTestResults",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				LotExpirationDate = "LotExpirationDate",
				LotNumber = "LotNumber",
				PatientGuid = "PatientGuid",
				PatientId = "PatientId",
				PatientName = "PatientName",
				ReagentManufacturerName = "ReagentManufacturerName",
				ReagentName = "ReagentName",
				ReagentTypeName = "ReagentTypeName",
				SpecimenUid = "SpecimenUid",
				TestingTechName = "TestingTechName";
		}

		/// <summary>
		/// ExceptionPatientRestriction class
		/// </summary>
		public abstract class ExceptionPatientRestriction
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionPatientRestriction",
				DivisionCode = "DivisionCode",
				DonationType = "DonationType",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionPatientRestrictionGuid = "ExceptionPatientRestrictionGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				ProductCode = "ProductCode",
				ProductShortName = "ProductShortName",
				RestrictedPatientGuid = "RestrictedPatientGuid",
				RestrictedPatientId = "RestrictedPatientId",
				RestrictedPatientName = "RestrictedPatientName",
				SpecialTesting = "SpecialTesting",
				UnitAboRh = "UnitAboRh",
				UnitExpirationDate = "UnitExpirationDate",
				UnitGuid = "UnitGuid",
				UnitId = "UnitId";
		}

		/// <summary>
		/// ExceptionPatientTest class
		/// </summary>
		public abstract class ExceptionPatientTest
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionPatientTest",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionPatientTestGuid = "ExceptionPatientTestGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				PatientGuid = "PatientGuid",
				PatientId = "PatientId",
				PatientName = "PatientName",
				ReactivityPhase = "ReactivityPhase",
				SpecimenUid = "SpecimenUid",
				TestDate = "TestDate",
				TestingTechName = "TestingTechName",
				TestInterp = "TestInterp",
				TestName = "TestName",
				UnitGuid = "UnitGuid",
				UnitId = "UnitId";
		}

		/// <summary>
		/// ExceptionPatientTestInactivated class
		/// </summary>
		public abstract class ExceptionPatientTestInactivated
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionPatientTestInactivated",
				CurrentTechName = "CurrentTechName",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionPatientTestInactivatedGuid = "ExceptionPatientTestInactivatedGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				InactivationDate = "InactivationDate",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				PatientGuid = "PatientGuid",
				PatientId = "PatientId",
				PatientName = "PatientName",
				SpecimenUid = "SpecimenUid",
				TestingTechName = "TestingTechName",
				TestName = "TestName";
		}

		/// <summary>
		/// ExceptionQc class
		/// </summary>
		public abstract class ExceptionQc
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionQc",
				BloodUnitGuid = "BloodUnitGuid",
				CurrentResult = "CurrentResult",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionQcGuid = "ExceptionQcGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				LotExpirationDate = "LotExpirationDate",
				LotNumber = "LotNumber",
				PatientGuid = "PatientGuid",
				PreviousResult = "PreviousResult",
				RackName = "RackName",
				ReactivityPhase = "ReactivityPhase",
				ReagentManufacturerName = "ReagentManufacturerName",
				ReagentName = "ReagentName",
				ReagentTypeName = "ReagentTypeName",
				TestingTechName = "TestingTechName";
		}

		/// <summary>
		/// ExceptionQcInactivation class
		/// </summary>
		public abstract class ExceptionQcInactivation
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionQcInactivation",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionQcInactivationGuid = "ExceptionQcInactivationGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				ReagentRack = "ReagentRack",
				TestingTechName = "TestingTechName";
		}

		/// <summary>
		/// ExceptionQcInactivationReagent class
		/// </summary>
		public abstract class ExceptionQcInactivationReagent
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionQcInactivationReagent",
				CcResult = "CcResult",
				ExceptionQcInactivationGuid = "ExceptionQcInactivationGuid",
				ExceptionQcInactivationReagentGuid = "ExceptionQcInactivationReagentGuid",
				IatResult = "IatResult",
				IsResult = "IsResult",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				ReagentTypeName = "ReagentTypeName",
				TestWithName = "TestWithName";
		}

		/// <summary>
		/// ExceptionQcNotPerformed class
		/// </summary>
		public abstract class ExceptionQcNotPerformed
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionQcNotPerformed",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionQcNotPerformedGuid = "ExceptionQcNotPerformedGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				PatientGuid = "PatientGuid",
				PatientId = "PatientId",
				PatientName = "PatientName",
				ProductCode = "ProductCode",
				RackName = "RackName",
				SpecimenUid = "SpecimenUid",
				TestingTechName = "TestingTechName",
				UnitId = "UnitId";
		}

		/// <summary>
		/// ExceptionQuarantine class
		/// </summary>
		public abstract class ExceptionQuarantine
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionQuarantine",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionQuarantineGuid = "ExceptionQuarantineGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				PatientGuid = "PatientGuid",
				PatientId = "PatientId",
				PatientName = "PatientName",
				TestingTechName = "TestingTechName",
				UnitAboRh = "UnitAboRh",
				UnitAntigenTypingResult = "UnitAntigenTypingResult",
				UnitExpirationDate = "UnitExpirationDate",
				UnitGuid = "UnitGuid",
				UnitId = "UnitId",
				UnitProductCode = "UnitProductCode",
				UnitProductType = "UnitProductType";
		}

		/// <summary>
		/// ExceptionRackTest class
		/// </summary>
		public abstract class ExceptionRackTest
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionRackTest",
				DateNotPerformed = "DateNotPerformed",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionRackTestGuid = "ExceptionRackTestGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				ReagentRack = "ReagentRack",
				TestingTechName = "TestingTechName";
		}

		/// <summary>
		/// ExceptionReflexTest class
		/// </summary>
		public abstract class ExceptionReflexTest
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionReflexTest",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionReflexTestGuid = "ExceptionReflexTestGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				PatientGuid = "PatientGuid",
				PatientId = "PatientId",
				PatientName = "PatientName",
				SpecimenExpirationDate = "SpecimenExpirationDate",
				SpecimenUid = "SpecimenUid",
				TestingTechName = "TestingTechName",
				TestOrdered = "TestOrdered";
		}

		/// <summary>
		/// ExceptionRemoveFinalUnitStatus class
		/// </summary>
		public abstract class ExceptionRemoveFinalUnitStatus
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionRemoveFinalUnitStatus",
				CurrentUnitExpirationDate = "CurrentUnitExpirationDate",
				CurrentUnitProductType = "CurrentUnitProductType",
				CurrentUnitStatus = "CurrentUnitStatus",
				CurrentUnitVolume = "CurrentUnitVolume",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionRemoveFinalUnitStatusGuid = "ExceptionRemoveFinalUnitStatusGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				PreviousUnitExpirationDate = "PreviousUnitExpirationDate",
				PreviousUnitProductType = "PreviousUnitProductType",
				PreviousUnitStatus = "PreviousUnitStatus",
				PreviousUnitVolume = "PreviousUnitVolume",
				UnitAboRh = "UnitAboRh",
				UnitGuid = "UnitGuid",
				UnitId = "UnitId";
		}

		/// <summary>
		/// ExceptionReturnedUnit class
		/// </summary>
		public abstract class ExceptionReturnedUnit
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionReturnedUnit",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionReturnedUnitGuid = "ExceptionReturnedUnitGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				IssueToLocation = "IssueToLocation",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				PatientAboRh = "PatientAboRh",
				PatientGuid = "PatientGuid",
				PatientId = "PatientId",
				PatientName = "PatientName",
				ProcessingTechName = "ProcessingTechName",
				ReturnedUnitAboRh = "ReturnedUnitAboRh",
				ReturnedUnitExpirationDate = "ReturnedUnitExpirationDate",
				ReturnedUnitGuid = "ReturnedUnitGuid",
				ReturnedUnitId = "ReturnedUnitId",
				ReturnedUnitProductShortName = "ReturnedUnitProductShortName",
				VisualInspectionIndicator = "VisualInspectionIndicator";
		}

		/// <summary>
		/// ExceptionSpecimen class
		/// </summary>
		public abstract class ExceptionSpecimen
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionSpecimen",
				ComponentClassOrdered = "ComponentClassOrdered",
				DateOrderAccepted = "DateOrderAccepted",
				DateWanted = "DateWanted",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionSpecimenGuid = "ExceptionSpecimenGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				ExtendedExpirationDate = "ExtendedExpirationDate",
				LastTransfusionDateTime = "LastTransfusionDateTime",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				PatientAntibodies = "PatientAntibodies",
				PatientGuid = "PatientGuid",
				PatientId = "PatientId",
				PatientName = "PatientName",
				SpecimenExpirationDate = "SpecimenExpirationDate",
				SpecimenUid = "SpecimenUid",
				TestingTechName = "TestingTechName";
		}

		/// <summary>
		/// ExceptionTransfusion class
		/// </summary>
		public abstract class ExceptionTransfusion
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionTransfusion",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionTransfusionGuid = "ExceptionTransfusionGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				TransfusedPatientAboRh = "TransfusedPatientAboRh",
				TransfusedPatientGuid = "TransfusedPatientGuid",
				TransfusedPatientId = "TransfusedPatientId",
				TransfusedPatientName = "TransfusedPatientName",
				UnitAboRh = "UnitAboRh",
				UnitExpirationDate = "UnitExpirationDate",
				UnitGuid = "UnitGuid",
				UnitId = "UnitId",
				UnitProductType = "UnitProductType";
		}

		/// <summary>
		/// ExceptionTransfusionReactionWorkup class
		/// </summary>
		public abstract class ExceptionTransfusionReactionWorkup
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionTransfusionReactionWorkup",
				AssignedPatientGuid = "AssignedPatientGuid",
				AssignedPatientId = "AssignedPatientId",
				AssignedPatientName = "AssignedPatientName",
				ClericalCheckFailed = "ClericalCheckFailed",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionTransfusionReactionWorkupGuid = "ExceptionTransfusionReactionWorkupGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				IssueDate = "IssueDate",
				IssueTechId = "IssueTechId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				ProductCode = "ProductCode",
				ProductShortName = "ProductShortName",
				TrwDate = "TrwDate",
				TrwPatientGuid = "TrwPatientGuid",
				TrwPatientId = "TrwPatientId",
				TrwPatientName = "TrwPatientName",
				TrwTechId = "TrwTechId",
				UnitAboRh = "UnitAboRh",
				UnitDonationType = "UnitDonationType",
				UnitExpirationDate = "UnitExpirationDate",
				UnitGuid = "UnitGuid",
				UnitId = "UnitId";
		}

		/// <summary>
		/// ExceptionTrwSpecimen class
		/// </summary>
		public abstract class ExceptionTrwSpecimen
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionTrwSpecimen",
				ClericalCheckFailed = "ClericalCheckFailed",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionTrwSpecimenGuid = "ExceptionTrwSpecimenGuid",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				SpecimenPatientGuid = "SpecimenPatientGuid",
				SpecimenPatientId = "SpecimenPatientId",
				SpecimenPatientName = "SpecimenPatientName",
				SpecimenUid = "SpecimenUid",
				TrwDate = "TrwDate",
				TrwPatientGuid = "TrwPatientGuid",
				TrwPatientId = "TrwPatientId",
				TrwPatientName = "TrwPatientName",
				TrwTechId = "TrwTechId";
		}

		/// <summary>
		/// ExceptionType class
		/// </summary>
		public abstract class ExceptionType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionType",
				BusinessRule = "BusinessRule",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionTypeName = "ExceptionTypeName",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// ExceptionUnitAboRh class
		/// </summary>
		public abstract class ExceptionUnitAboRh
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionUnitAboRh",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUnitAboRhGuid = "ExceptionUnitAboRhGuid",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				LoginUnitAboRh = "LoginUnitAboRh",
				TestingTechName = "TestingTechName",
				UnitAboRhInterp = "UnitAboRhInterp",
				UnitExpirationDate = "UnitExpirationDate",
				UnitGuid = "UnitGuid",
				UnitId = "UnitId",
				UnitProductType = "UnitProductType";
		}

		/// <summary>
		/// ExceptionUnitIssue class
		/// </summary>
		public abstract class ExceptionUnitIssue
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionUnitIssue",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUnitIssueGuid = "ExceptionUnitIssueGuid",
				ExceptionUser = "ExceptionUser",
				HistoricAboRh = "HistoricAboRh",
				IssueDateTime = "IssueDateTime",
				IssuedToLocation = "IssuedToLocation",
				IssuingTechName = "IssuingTechName",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				LoginTechName = "LoginTechName",
				OrderedBy = "OrderedBy",
				OrderIndicator = "OrderIndicator",
				PatientAntibodies = "PatientAntibodies",
				PatientGuid = "PatientGuid",
				PatientId = "PatientId",
				PatientName = "PatientName",
				PatientTransfusionRequirements = "PatientTransfusionRequirements",
				SpecimenUid = "SpecimenUid",
				SystemAboRh = "SystemAboRh",
				TechAboRh = "TechAboRh",
				TransporterName = "TransporterName",
				UnitAboRh = "UnitAboRh",
				UnitAntigens = "UnitAntigens",
				UnitDonationType = "UnitDonationType",
				UnitExpirationDate = "UnitExpirationDate",
				UnitGuid = "UnitGuid",
				UnitId = "UnitId",
				UnitProductType = "UnitProductType",
				UnitTestingEntry = "UnitTestingEntry";
		}

		/// <summary>
		/// ExceptionUnitModification class
		/// </summary>
		public abstract class ExceptionUnitModification
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionUnitModification",
				ComponentName = "ComponentName",
				DivisionCode = "DivisionCode",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUnitModificationGuid = "ExceptionUnitModificationGuid",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				ModificationDate = "ModificationDate",
				ModificationType = "ModificationType",
				ModifyingTech = "ModifyingTech",
				RecommendedExpirationDate = "RecommendedExpirationDate",
				SupplyExpirationDate = "SupplyExpirationDate",
				SupplyLotNumber = "SupplyLotNumber",
				SupplyName = "SupplyName",
				SupplyType = "SupplyType",
				UnitAboRh = "UnitAboRh",
				UnitCost = "UnitCost",
				UnitExpirationDate = "UnitExpirationDate",
				UnitGuid = "UnitGuid",
				UnitId = "UnitId",
				UnitProductCode = "UnitProductCode",
				UnitProductType = "UnitProductType";
		}

		/// <summary>
		/// ExceptionUnitSelection class
		/// </summary>
		public abstract class ExceptionUnitSelection
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ExceptionUnitSelection",
				AntigenNegativeRequirements = "AntigenNegativeRequirements",
				AntigenTypingResult = "AntigenTypingResult",
				ComponentRequirements = "ComponentRequirements",
				DivisionCode = "DivisionCode",
				DonationType = "DonationType",
				ExceptionComment = "ExceptionComment",
				ExceptionDate = "ExceptionDate",
				ExceptionTypeId = "ExceptionTypeId",
				ExceptionUnitSelectionGuid = "ExceptionUnitSelectionGuid",
				ExceptionUser = "ExceptionUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateUser = "LastUpdateUser",
				PatientAntibodies = "PatientAntibodies",
				PatientCurrentAboRh = "PatientCurrentAboRh",
				PatientGuid = "PatientGuid",
				PatientHistoricalAboRh = "PatientHistoricalAboRh",
				PatientId = "PatientId",
				PatientName = "PatientName",
				SelectionDate = "SelectionDate",
				TestingTechName = "TestingTechName",
				UnitAboRh = "UnitAboRh",
				UnitExpirationDate = "UnitExpirationDate",
				UnitGuid = "UnitGuid",
				UnitId = "UnitId",
				UnitProductType = "UnitProductType";
		}

		/// <summary>
		/// Facility class
		/// </summary>
		public abstract class Facility
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "Facility",
				AddressGuid = "AddressGuid",
				CollectionIndicator = "CollectionIndicator",
				FacilityGuid = "FacilityGuid",
				FacilityName = "FacilityName",
				FacilityPrefix = "FacilityPrefix",
				FaxNumber = "FaxNumber",
				FdaRegistrationNumber = "FdaRegistrationNumber",
				IccbbaRegistrationNumber = "IccbbaRegistrationNumber",
				LabelUnitIdTrimIndicator = "LabelUnitIdTrimIndicator",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				PhoneNumber = "PhoneNumber",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				TestingIndicator = "TestingIndicator";
		}

		/// <summary>
		/// HcpcsAssignment class
		/// </summary>
		public abstract class HcpcsAssignment
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "HcpcsAssignment",
				AssignedDate = "AssignedDate",
				BloodProductGuid = "BloodProductGuid",
				DivisionCode = "DivisionCode",
				HcpcsAssignmentGuid = "HcpcsAssignmentGuid",
				HcpcsCode = "HcpcsCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				UnAssignedDate = "UnAssignedDate";
		}

		/// <summary>
		/// HcpcsCache class
		/// </summary>
		public abstract class HcpcsCache
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "HcpcsCache",
				HcpcsCode = "HcpcsCode",
				HcpcsName = "HcpcsName",
				LastUpdateDate = "LastUpdateDate";
		}

		/// <summary>
		/// HemolysisInspection class
		/// </summary>
		public abstract class HemolysisInspection
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "HemolysisInspection",
				HemolysisInspectionCode = "HemolysisInspectionCode",
				HemolysisInspectionText = "HemolysisInspectionText",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// HospitalLocationCache class
		/// </summary>
		public abstract class HospitalLocationCache
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "HospitalLocationCache",
				LastUpdateDate = "LastUpdateDate",
				LocationDivision = "LocationDivision",
				LocationIen = "LocationIen",
				LocationName = "LocationName",
				LocationType = "LocationType";
		}

		/// <summary>
		/// IccbbaComponentClass class
		/// </summary>
		public abstract class IccbbaComponentClass
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "IccbbaComponentClass",
				ComponentClassId = "ComponentClassId",
				IccbbaComponentClassId = "IccbbaComponentClassId",
				IccbbaComponentClassName = "IccbbaComponentClassName",
				IccbbaComponentClassShortName = "IccbbaComponentClassShortName",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// InformationMessage class
		/// </summary>
		public abstract class InformationMessage
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "InformationMessage",
				InformationMessageId = "InformationMessageId",
				InformationMessageText = "InformationMessageText",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// Interface class
		/// </summary>
		public abstract class Interface
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "Interface",
				ApplicationAckType = "ApplicationAckType",
				EncodingCharacters = "EncodingCharacters",
				FieldSeparator = "FieldSeparator",
				InterfaceApplicationId = "InterfaceApplicationId",
				InterfaceId = "InterfaceId",
				InterfaceName = "InterfaceName",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				VbecsApplicationId = "VbecsApplicationId",
				VersionId = "VersionId";
		}

		/// <summary>
		/// InterfaceControl class
		/// </summary>
		public abstract class InterfaceControl
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "InterfaceControl",
				AckTimeout = "AckTimeout",
				InterfaceActiveIndicator = "InterfaceActiveIndicator",
				InterfaceAdministratorName = "InterfaceAdministratorName",
				InterfaceControlId = "InterfaceControlId",
				InterfaceDomainName = "InterfaceDomainName",
				InterfaceFacilityId = "InterfaceFacilityId",
				InterfaceId = "InterfaceId",
				InterfaceIPAddress = "InterfaceIPAddress",
				InterfacePortNumber = "InterfacePortNumber",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				LogEventsIndicator = "LogEventsIndicator",
				ProcessingId = "ProcessingId",
				PurgeSuccessfulMessage = "PurgeSuccessfulMessage",
				PurgeUnSuccessfulMessage = "PurgeUnSuccessfulMessage",
				ReTransmitAttempts = "ReTransmitAttempts",
				RowVersion = "RowVersion",
				VbecsFacilityId = "VbecsFacilityId",
				VbecsIPAddress = "VbecsIPAddress",
				VbecsPortNumber = "VbecsPortNumber";
		}

		/// <summary>
		/// IssuedUnit class
		/// </summary>
		public abstract class IssuedUnit
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "IssuedUnit",
				BloodUnitGuid = "BloodUnitGuid",
				InPatientLocationIndicator = "InPatientLocationIndicator",
				IssueDateTime = "IssueDateTime",
				IssuedUnitGuid = "IssuedUnitGuid",
				IssueSatisfactoryIndicator = "IssueSatisfactoryIndicator",
				IssueTechId = "IssueTechId",
				IssueToLocationName = "IssueToLocationName",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				LocationIen = "LocationIen",
				PatientGuid = "PatientGuid",
				PhysicianName = "PhysicianName",
				RemoteStorageIndicator = "RemoteStorageIndicator",
				RemoteStorageText = "RemoteStorageText",
				ReturnDateTime = "ReturnDateTime",
				ReturnFromLocationName = "ReturnFromLocationName",
				ReturnSatisfactoryIndicator = "ReturnSatisfactoryIndicator",
				ReturnTechId = "ReturnTechId",
				RowVersion = "RowVersion",
				TransporterName = "TransporterName";
		}

		/// <summary>
		/// IssuedUnitComment class
		/// </summary>
		public abstract class IssuedUnitComment
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "IssuedUnitComment",
				DivisionCode = "DivisionCode",
				EntryDate = "EntryDate",
				EntryTechId = "EntryTechId",
				IssuedUnitCommentGuid = "IssuedUnitCommentGuid",
				IssuedUnitCommentText = "IssuedUnitCommentText",
				IssuedUnitGuid = "IssuedUnitGuid",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// LabelType class
		/// </summary>
		public abstract class LabelType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "LabelType",
				LabelTypeCode = "LabelTypeCode",
				LabelTypeText = "LabelTypeText",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// LocalSupplier class
		/// </summary>
		public abstract class LocalSupplier
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "LocalSupplier",
				AddressGuid = "AddressGuid",
				CollectionIndicator = "CollectionIndicator",
				DivisionCode = "DivisionCode",
				FacilityGuid = "FacilityGuid",
				FacilityName = "FacilityName",
				FacilityPrefix = "FacilityPrefix",
				FaxNumber = "FaxNumber",
				FdaRegistrationNumber = "FdaRegistrationNumber",
				IccbbaRegistrationNumber = "IccbbaRegistrationNumber",
				LabelUnitIdTrimIndicator = "LabelUnitIdTrimIndicator",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				LocalSupplierGuid = "LocalSupplierGuid",
				PhoneNumber = "PhoneNumber",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				TestingIndicator = "TestingIndicator";
		}

		/// <summary>
		/// LoginMessage class
		/// </summary>
		public abstract class LoginMessage
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "LoginMessage",
				DivisionCode = "DivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				LoginMessageGuid = "LoginMessageGuid",
				LoginMessageText = "LoginMessageText",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// MessageLog class
		/// </summary>
		public abstract class MessageLog
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "MessageLog",
				AckMessageControlId = "AckMessageControlId",
				DateTimeOfMessage = "DateTimeOfMessage",
				ErrorText = "ErrorText",
				InterfaceControlId = "InterfaceControlId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MessageControlId = "MessageControlId",
				MessageLogId = "MessageLogId",
				MessageStatusCode = "MessageStatusCode",
				MessageStream = "MessageStream",
				MessageType = "MessageType",
				ReceivingApplication = "ReceivingApplication",
				RowVersion = "RowVersion",
				SendingApplication = "SendingApplication",
				TransmitCount = "TransmitCount";
		}

		/// <summary>
		/// MessageStatus class
		/// </summary>
		public abstract class MessageStatus
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "MessageStatus",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MessageStatusCode = "MessageStatusCode",
				MessageStatusText = "MessageStatusText",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// MessageType class
		/// </summary>
		public abstract class MessageType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "MessageType",
				EventContext = "EventContext",
				InterfaceControlId = "InterfaceControlId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MessageType_Column = "MessageType",
				MessageTypeId = "MessageTypeId",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				TriggerEvent = "TriggerEvent";
		}

		/// <summary>
		/// ModificationEquipment class
		/// </summary>
		public abstract class ModificationEquipment
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ModificationEquipment",
				BloodUnitModificationGuid = "BloodUnitModificationGuid",
				EquipmentGuid = "EquipmentGuid",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				ModificationEquipmentGuid = "ModificationEquipmentGuid",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// ModificationMethod class
		/// </summary>
		public abstract class ModificationMethod
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ModificationMethod",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				ModificationMethodCode = "ModificationMethodCode",
				ModificationMethodText = "ModificationMethodText",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// ModificationSupply class
		/// </summary>
		public abstract class ModificationSupply
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ModificationSupply",
				BloodUnitModificationGuid = "BloodUnitModificationGuid",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				ModificationSupplyGuid = "ModificationSupplyGuid",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				SupplyGuid = "SupplyGuid";
		}

		/// <summary>
		/// Msbos class
		/// </summary>
		public abstract class Msbos
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "Msbos",
				DivisionCode = "DivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MsbosGuid = "MsbosGuid",
				NoBloodRequiredIndicator = "NoBloodRequiredIndicator",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				SurgeryName = "SurgeryName",
				TypeAndScreenIndicator = "TypeAndScreenIndicator";
		}

		/// <summary>
		/// MsbosComponentClass class
		/// </summary>
		public abstract class MsbosComponentClass
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "MsbosComponentClass",
				ComponentClassId = "ComponentClassId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MaximumSetupUnitQuantity = "MaximumSetupUnitQuantity",
				MsbosComponentClassGuid = "MsbosComponentClassGuid",
				MsbosGuid = "MsbosGuid",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// OrderableTest class
		/// </summary>
		public abstract class OrderableTest
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "OrderableTest",
				CprsOrderableItemId = "CprsOrderableItemId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OrderableTestId = "OrderableTestId",
				OrderableTestName = "OrderableTestName",
				OrderableTestText = "OrderableTestText",
				ReagentTypeId = "ReagentTypeId",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// OrderAlertType class
		/// </summary>
		public abstract class OrderAlertType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "OrderAlertType",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OrderAlertTypeCode = "OrderAlertTypeCode",
				OrderAlertTypeText = "OrderAlertTypeText",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// OrderedComponent class
		/// </summary>
		public abstract class OrderedComponent
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "OrderedComponent",
				CancellationCannedCommentGuid = "CancellationCannedCommentGuid",
				CancellationText = "CancellationText",
				ComponentClassId = "ComponentClassId",
				CprsOrderNumber = "CprsOrderNumber",
				DivisionCode = "DivisionCode",
				EmergencyOrderIndicator = "EmergencyOrderIndicator",
				ImmediateTransfusionIndicator = "ImmediateTransfusionIndicator",
				InappropriateRequestIndicator = "InappropriateRequestIndicator",
				LabOrderNumber = "LabOrderNumber",
				LabTestId = "LabTestId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				NoInappropriateReportText = "NoInappropriateReportText",
				OrderAcceptanceDate = "OrderAcceptanceDate",
				OrderedComponentComments = "OrderedComponentComments",
				OrderedComponentGuid = "OrderedComponentGuid",
				OrderSpecialInstructions = "OrderSpecialInstructions",
				OrderStatusCode = "OrderStatusCode",
				OrderUrgencyCode = "OrderUrgencyCode",
				PatientOrderGuid = "PatientOrderGuid",
				PatientSpecimenGuid = "PatientSpecimenGuid",
				PreOpIndicator = "PreOpIndicator",
				RequiredDatetime = "RequiredDatetime",
				RequiredUnitQuantity = "RequiredUnitQuantity",
				RowVersion = "RowVersion",
				SpecimenAccessionNumber = "SpecimenAccessionNumber",
				SpecimenRequiredIndicator = "SpecimenRequiredIndicator",
				SpecimenStatusCode = "SpecimenStatusCode",
				SpecimenWorkloadUid = "SpecimenWorkloadUid",
				TaskStatusCode = "TaskStatusCode",
				VbecsOrderNumber = "VbecsOrderNumber";
		}

		/// <summary>
		/// OrderedTest class
		/// </summary>
		public abstract class OrderedTest
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "OrderedTest",
				AutoInstrumentName = "AutoInstrumentName",
				CancellationCannedCommentGuid = "CancellationCannedCommentGuid",
				CancellationText = "CancellationText",
				CprsOrderNumber = "CprsOrderNumber",
				DivisionCode = "DivisionCode",
				LabOrderNumber = "LabOrderNumber",
				LabTestId = "LabTestId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OrderableTestId = "OrderableTestId",
				OrderAcceptanceDate = "OrderAcceptanceDate",
				OrderedTestComments = "OrderedTestComments",
				OrderedTestGuid = "OrderedTestGuid",
				OrderStatusCode = "OrderStatusCode",
				OrderUrgencyCode = "OrderUrgencyCode",
				PatientOrderGuid = "PatientOrderGuid",
				PatientSpecimenGuid = "PatientSpecimenGuid",
				RelatedComponentGuid = "RelatedComponentGuid",
				RelatedTestGuid = "RelatedTestGuid",
				RequiredResultsDate = "RequiredResultsDate",
				RowVersion = "RowVersion",
				SpecimenAccessionNumber = "SpecimenAccessionNumber",
				SpecimenRequiredIndicator = "SpecimenRequiredIndicator",
				SpecimenWorkloadUid = "SpecimenWorkloadUid",
				TaskStatusCode = "TaskStatusCode",
				TestInterpretation = "TestInterpretation",
				TestInterpretationComments = "TestInterpretationComments",
				VbecsOrderNumber = "VbecsOrderNumber";
		}

		/// <summary>
		/// OrderedUnit class
		/// </summary>
		public abstract class OrderedUnit
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "OrderedUnit",
				BloodUnitGuid = "BloodUnitGuid",
				CrossmatchDate = "CrossmatchDate",
				CrossmatchRequiredIndicator = "CrossmatchRequiredIndicator",
				CrossmatchResultCode = "CrossmatchResultCode",
				CrossmatchTechId = "CrossmatchTechId",
				DivisionCode = "DivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OrderedComponentGuid = "OrderedComponentGuid",
				OrderedTestGuid = "OrderedTestGuid",
				OrderedUnitGuid = "OrderedUnitGuid",
				RecordStatusCode = "RecordStatusCode",
				ReleaseDate = "ReleaseDate",
				ReleaseTechId = "ReleaseTechId",
				RowVersion = "RowVersion",
				SelectedDate = "SelectedDate",
				SelectedTechId = "SelectedTechId";
		}

		/// <summary>
		/// OrderedUnitComment class
		/// </summary>
		public abstract class OrderedUnitComment
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "OrderedUnitComment",
				CannedCommentGuid = "CannedCommentGuid",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OrderedUnitCommentGuid = "OrderedUnitCommentGuid",
				OrderedUnitCommentText = "OrderedUnitCommentText",
				OrderedUnitGuid = "OrderedUnitGuid",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// OrderStatus class
		/// </summary>
		public abstract class OrderStatus
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "OrderStatus",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OrderStatusCode = "OrderStatusCode",
				OrderStatusText = "OrderStatusText",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// OrderUrgency class
		/// </summary>
		public abstract class OrderUrgency
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "OrderUrgency",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OrderUrgencyCode = "OrderUrgencyCode",
				OrderUrgencyText = "OrderUrgencyText",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// Patient class
		/// </summary>
		public abstract class Patient
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "Patient",
				AboRhChangeIndicator = "AboRhChangeIndicator",
				BloodTypeCode = "BloodTypeCode",
				DisplayVistaPatientId = "DisplayVistaPatientId",
				FinalMergeToPatient = "FinalMergeToPatient",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MergeFromPatient = "MergeFromPatient",
				MergeToPatient = "MergeToPatient",
				PatientDeathDate = "PatientDeathDate",
				PatientDob = "PatientDob",
				PatientDobCode = "PatientDobCode",
				PatientFirstName = "PatientFirstName",
				PatientGuid = "PatientGuid",
				PatientIcn = "PatientIcn",
				PatientLastName = "PatientLastName",
				PatientMergeDate = "PatientMergeDate",
				PatientMergeGroup = "PatientMergeGroup",
				PatientMiddleName = "PatientMiddleName",
				PatientNamePrefix = "PatientNamePrefix",
				PatientNameSuffix = "PatientNameSuffix",
				PatientServiceBranch = "PatientServiceBranch",
				PatientSexCode = "PatientSexCode",
				PatientSsn = "PatientSsn",
				RecordStatusCode = "RecordStatusCode",
				RhFactorCode = "RhFactorCode",
				RowVersion = "RowVersion",
				SsnPrefix = "SsnPrefix",
				SsnPseudoIndicator = "SsnPseudoIndicator",
				VistaPatientId = "VistaPatientId";
		}

		/// <summary>
		/// PatientChange class
		/// </summary>
		public abstract class PatientChange
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "PatientChange",
				ActiveDivisionsAlertViewed = "ActiveDivisionsAlertViewed",
				FromPatientDeathDate = "FromPatientDeathDate",
				FromPatientDob = "FromPatientDob",
				FromPatientFirstName = "FromPatientFirstName",
				FromPatientGuid = "FromPatientGuid",
				FromPatientIcn = "FromPatientIcn",
				FromPatientLastName = "FromPatientLastName",
				FromPatientMIddleName = "FromPatientMIddleName",
				FromPatientSexCode = "FromPatientSexCode",
				FromPatientSsn = "FromPatientSsn",
				FromSsnPseudoIndicator = "FromSsnPseudoIndicator",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MergeFromVistaPatientId = "MergeFromVistaPatientId",
				MergeToVistaPatientId = "MergeToVistaPatientId",
				NotificationReceivedDate = "NotificationReceivedDate",
				PatientChangeGuid = "PatientChangeGuid",
				PatientChangeStatusCode = "PatientChangeStatusCode",
				RowVersion = "RowVersion",
				ToPatientDeathDate = "ToPatientDeathDate",
				ToPatientDob = "ToPatientDob",
				ToPatientFirstName = "ToPatientFirstName",
				ToPatientGuid = "ToPatientGuid",
				ToPatientIcn = "ToPatientIcn",
				ToPatientLastName = "ToPatientLastName",
				ToPatientMIddleName = "ToPatientMIddleName",
				ToPatientSexCode = "ToPatientSexCode",
				ToPatientSsn = "ToPatientSsn",
				ToSsnPseudoIndicator = "ToSsnPseudoIndicator";
		}

		/// <summary>
		/// PatientChangeStatus class
		/// </summary>
		public abstract class PatientChangeStatus
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "PatientChangeStatus",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				PatientChangeStatusCode = "PatientChangeStatusCode",
				PatientChangeStatusText = "PatientChangeStatusText",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// PatientDob class
		/// </summary>
		public abstract class PatientDob
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "PatientDob",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				PatientDobCode = "PatientDobCode",
				PatientDobText = "PatientDobText",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// PatientLocation class
		/// </summary>
		public abstract class PatientLocation
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "PatientLocation",
				DivisionCode = "DivisionCode",
				InPatientIndicator = "InPatientIndicator",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				LocationName = "LocationName",
				LocationRoomBed = "LocationRoomBed",
				PatientGuid = "PatientGuid",
				PatientLocationGuid = "PatientLocationGuid",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// PatientOrder class
		/// </summary>
		public abstract class PatientOrder
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "PatientOrder",
				DivisionCode = "DivisionCode",
				InformedConsentIndicator = "InformedConsentIndicator",
				InstitutionDivisionCode = "InstitutionDivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OrderComments = "OrderComments",
				OrderEnteredByFirstName = "OrderEnteredByFirstName",
				OrderEnteredById = "OrderEnteredById",
				OrderEnteredByLastName = "OrderEnteredByLastName",
				OrderEnteredByMiddleInitial = "OrderEnteredByMiddleInitial",
				OrderGroupNumber = "OrderGroupNumber",
				OrderingHospitalLocation = "OrderingHospitalLocation",
				OrderingProviderFirstName = "OrderingProviderFirstName",
				OrderingProviderId = "OrderingProviderId",
				OrderingProviderLastName = "OrderingProviderLastName",
				OrderingProviderMiddleInitial = "OrderingProviderMiddleInitial",
				OrderPlacedDatetime = "OrderPlacedDatetime",
				OrderReceivedDatetime = "OrderReceivedDatetime",
				PatientOrderGuid = "PatientOrderGuid",
				PatientTreatmentGuid = "PatientTreatmentGuid",
				RequestReason = "RequestReason",
				RowVersion = "RowVersion",
				SpecimenRequiredIndicator = "SpecimenRequiredIndicator",
				SurgeryName = "SurgeryName";
		}

		/// <summary>
		/// PatientSpecialInstruction class
		/// </summary>
		public abstract class PatientSpecialInstruction
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "PatientSpecialInstruction",
				CreateDate = "CreateDate",
				CreateUser = "CreateUser",
				DivisionCode = "DivisionCode",
				InactivateDate = "InactivateDate",
				InactivateUser = "InactivateUser",
				InactivationComment = "InactivationComment",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				PatientGuid = "PatientGuid",
				PatientSpecialInstructionGuid = "PatientSpecialInstructionGuid",
				PatientSpecialInstructions = "PatientSpecialInstructions",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				VistaConversionIndicator = "VistaConversionIndicator";
		}

		/// <summary>
		/// PatientSpecimen class
		/// </summary>
		public abstract class PatientSpecimen
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "PatientSpecimen",
				CannedCommentGuid = "CannedCommentGuid",
				DivisionCode = "DivisionCode",
				EntryTechId = "EntryTechId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MaintainableSpecimenIndicator = "MaintainableSpecimenIndicator",
				PatientGuid = "PatientGuid",
				PatientSpecimenGuid = "PatientSpecimenGuid",
				PhlebotomistId = "PhlebotomistId",
				PostTransfusionIndicator = "PostTransfusionIndicator",
				RowVersion = "RowVersion",
				SpecimenAccessionNumber = "SpecimenAccessionNumber",
				SpecimenCollectionDate = "SpecimenCollectionDate",
				SpecimenComments = "SpecimenComments",
				SpecimenExpirationDate = "SpecimenExpirationDate",
				SpecimenReceivedDate = "SpecimenReceivedDate",
				SpecimenSource = "SpecimenSource",
				SpecimenStatusCode = "SpecimenStatusCode",
				SpecimenUid = "SpecimenUid",
				UnacceptableSpecimenIndicator = "UnacceptableSpecimenIndicator",
				VbecsSpecimenNumber = "VbecsSpecimenNumber";
		}

		/// <summary>
		/// PatientSymptom class
		/// </summary>
		public abstract class PatientSymptom
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "PatientSymptom",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				PatientSymptomId = "PatientSymptomId",
				PatientSymptomName = "PatientSymptomName",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// PatientTest class
		/// </summary>
		public abstract class PatientTest
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "PatientTest",
				DivisionCode = "DivisionCode",
				LabTestId = "LabTestId",
				LabTestNormalRange = "LabTestNormalRange",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OrderableTestId = "OrderableTestId",
				PatientGuid = "PatientGuid",
				PatientOrderGuid = "PatientOrderGuid",
				PatientTestGuid = "PatientTestGuid",
				RecordStatusCode = "RecordStatusCode",
				ResultDateTime = "ResultDateTime",
				RowVersion = "RowVersion",
				TestComments = "TestComments",
				TestDate = "TestDate",
				TestResult = "TestResult";
		}

		/// <summary>
		/// PatientTransfusion class
		/// </summary>
		public abstract class PatientTransfusion
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "PatientTransfusion",
				ApplicationOfRecordId = "ApplicationOfRecordId",
				BedsideVerificationDate = "BedsideVerificationDate",
				BedsideVerificationUnitManualEntryReason = "BedsideVerificationUnitManualEntryReason",
				BloodUnitGuid = "BloodUnitGuid",
				DivisionCode = "DivisionCode",
				DssExtractSuccessIndicator = "DssExtractSuccessIndicator",
				InterruptionComment = "InterruptionComment",
				InterruptionDateTime = "InterruptionDateTime",
				InterruptionIndicator = "InterruptionIndicator",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				LocationIen = "LocationIen",
				OtherDifficultyIndicator = "OtherDifficultyIndicator",
				OtherDifficultyText = "OtherDifficultyText",
				PatientGuid = "PatientGuid",
				PatientSpecimenGuid = "PatientSpecimenGuid",
				PatientTransfusionGuid = "PatientTransfusionGuid",
				PhlebotomistId = "PhlebotomistId",
				ReactionIndicator = "ReactionIndicator",
				ReactionSymptoms = "ReactionSymptoms",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				TransfusedVolume = "TransfusedVolume",
				TransfusionEndDateTime = "TransfusionEndDateTime",
				Transfusionist1Id = "Transfusionist1Id",
				Transfusionist2Id = "Transfusionist2Id",
				TransfusionLocation = "TransfusionLocation",
				TransfusionPooledUnitsCount = "TransfusionPooledUnitsCount",
				TransfusionStartDateTime = "TransfusionStartDateTime";
		}

		/// <summary>
		/// PatientTransfusionComment class
		/// </summary>
		public abstract class PatientTransfusionComment
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "PatientTransfusionComment",
				CannedCommentGuid = "CannedCommentGuid",
				CommentCategoryCode = "CommentCategoryCode",
				DivisionCode = "DivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				PatientTransfusionCommentGuid = "PatientTransfusionCommentGuid",
				PatientTransfusionCommentText = "PatientTransfusionCommentText",
				PatientTransfusionGuid = "PatientTransfusionGuid",
				PatientTransfusionReactionGuid = "PatientTransfusionReactionGuid",
				PreTransfusionIndicator = "PreTransfusionIndicator",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// PatientTransfusionReaction class
		/// </summary>
		public abstract class PatientTransfusionReaction
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "PatientTransfusionReaction",
				DivisionCode = "DivisionCode",
				EntryDateTime = "EntryDateTime",
				EntryTechId = "EntryTechId",
				InvestigatedDateTime = "InvestigatedDateTime",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MedicalDirectorName = "MedicalDirectorName",
				NotedDateTime = "NotedDateTime",
				OrderedTestGuid = "OrderedTestGuid",
				PartialSaveId = "PartialSaveId",
				PatientGuid = "PatientGuid",
				PatientTransfusionReactionGuid = "PatientTransfusionReactionGuid",
				PostSpecimenClericalChecksOkIndicator = "PostSpecimenClericalChecksOkIndicator",
				PostSpecimenGuid = "PostSpecimenGuid",
				PostSpecimenHemolysisInspectionCode = "PostSpecimenHemolysisInspectionCode",
				PostSpecimenNotAvailableIndicator = "PostSpecimenNotAvailableIndicator",
				PreSpecimenClericalChecksOkIndicator = "PreSpecimenClericalChecksOkIndicator",
				PreSpecimenGuid = "PreSpecimenGuid",
				PreSpecimenHemolysisInspectionCode = "PreSpecimenHemolysisInspectionCode",
				PreSpecimenNotAvailableIndicator = "PreSpecimenNotAvailableIndicator",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				TransfusionReactionTypeCode = "TransfusionReactionTypeCode";
		}

		/// <summary>
		/// PatientTransfusionReactionSymptom class
		/// </summary>
		public abstract class PatientTransfusionReactionSymptom
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "PatientTransfusionReactionSymptom",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				PatientSymptomId = "PatientSymptomId",
				PatientTransfusionReactionGuid = "PatientTransfusionReactionGuid",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// PatientTransfusionRequirement class
		/// </summary>
		public abstract class PatientTransfusionRequirement
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "PatientTransfusionRequirement",
				AntibodyLastLocation = "AntibodyLastLocation",
				AntibodyTypeId = "AntibodyTypeId",
				AntigenTypeId = "AntigenTypeId",
				ComponentRequirementId = "ComponentRequirementId",
				CreateDate = "CreateDate",
				CreateDivisionCode = "CreateDivisionCode",
				CreateUser = "CreateUser",
				InactivateDate = "InactivateDate",
				InactivateDivisionCode = "InactivateDivisionCode",
				InactivateUser = "InactivateUser",
				InactivationComment = "InactivationComment",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				PatientGuid = "PatientGuid",
				PatientTransfusionRequirementGuid = "PatientTransfusionRequirementGuid",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				SpecimenTestGuid = "SpecimenTestGuid",
				TransfusionRequirementCategoryCode = "TransfusionRequirementCategoryCode",
				TransfusionRequirementText = "TransfusionRequirementText",
				VistaConversionIndicator = "VistaConversionIndicator";
		}

		/// <summary>
		/// PatientTreatment class
		/// </summary>
		public abstract class PatientTreatment
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "PatientTreatment",
				InPatientIndicator = "InPatientIndicator",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				PatientAdmittingDiagnosis = "PatientAdmittingDiagnosis",
				PatientGuid = "PatientGuid",
				PatientLocation = "PatientLocation",
				PatientRoomBed = "PatientRoomBed",
				PatientTreatingFacility = "PatientTreatingFacility",
				PatientTreatmentGuid = "PatientTreatmentGuid",
				RowVersion = "RowVersion",
				TreatingSpecialtyCode = "TreatingSpecialtyCode";
		}

		/// <summary>
		/// PermittedProductModification class
		/// </summary>
		public abstract class PermittedProductModification
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "PermittedProductModification",
				AddTargetAttribute = "AddTargetAttribute",
				ExpirationDateRule = "ExpirationDateRule",
				FromCoreCondition = "FromCoreCondition",
				FromProductTypeCode = "FromProductTypeCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MethodSelect = "MethodSelect",
				PermittedProductModificationGuid = "PermittedProductModificationGuid",
				ProductModificationCode = "ProductModificationCode",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				ToCoreCondition = "ToCoreCondition",
				ToProductTypeCode = "ToProductTypeCode";
		}

		/// <summary>
		/// PoolCounter class
		/// </summary>
		public abstract class PoolCounter
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "PoolCounter",
				CounterValue = "CounterValue",
				CounterYear = "CounterYear",
				DivisionCode = "DivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				PoolCounterGuid = "PoolCounterGuid",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// ProductAttribute class
		/// </summary>
		public abstract class ProductAttribute
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ProductAttribute",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				ModificationAllowedIndicator = "ModificationAllowedIndicator",
				ProductAttributeId = "ProductAttributeId",
				ProductAttributePrintName = "ProductAttributePrintName",
				ProductAttributeText = "ProductAttributeText",
				RetireDate = "RetireDate",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// ProductModification class
		/// </summary>
		public abstract class ProductModification
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ProductModification",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				ProductModificationCode = "ProductModificationCode",
				ProductModificationText = "ProductModificationText",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// ProductModificationAttribute class
		/// </summary>
		public abstract class ProductModificationAttribute
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ProductModificationAttribute",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OptionalAttribute = "OptionalAttribute",
				ProductModificationAttributeId = "ProductModificationAttributeId",
				ProductModificationCode = "ProductModificationCode",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// ProductModificationParameter class
		/// </summary>
		public abstract class ProductModificationParameter
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ProductModificationParameter",
				DivisionCode = "DivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				ProductModificationCode = "ProductModificationCode",
				ProductModificationCost = "ProductModificationCost",
				ProductModificationParameterGuid = "ProductModificationParameterGuid",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// ProductShipper class
		/// </summary>
		public abstract class ProductShipper
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ProductShipper",
				BloodProductGuid = "BloodProductGuid",
				DivisionCode = "DivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				LocalSupplierGuid = "LocalSupplierGuid",
				ProductCost = "ProductCost",
				ProductShipperGuid = "ProductShipperGuid",
				RecordStatusCode = "RecordStatusCode",
				ReturnCreditPercentage = "ReturnCreditPercentage",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// ProductType class
		/// </summary>
		public abstract class ProductType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ProductType",
                AboRhConfirmationRequired = "AboRhConfirmationRequired",
				ComponentClassId = "ComponentClassId",
				IccbbaComponentClassId = "IccbbaComponentClassId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				ProductTypeCode = "ProductTypeCode",
				ProductTypeName = "ProductTypeName",
				ProductTypePrintName = "ProductTypePrintName",
				RetireDate = "RetireDate",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				SplitAllowedIndicator = "SplitAllowedIndicator";
		}

		/// <summary>
		/// Rack class
		/// </summary>
		public abstract class Rack
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "Rack",
				DailyControlGuid = "DailyControlGuid",
				DivisionCode = "DivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RackGuid = "RackGuid",
				RackName = "RackName",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// RackLot class
		/// </summary>
		public abstract class RackLot
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "RackLot",
				Comments = "Comments",
				ControlCellId = "ControlCellId",
				DailyQcWorklistGuid = "DailyQcWorklistGuid",
				DivisionCode = "DivisionCode",
				ExpectedMinimumReactions = "ExpectedMinimumReactions",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				LotUseDate = "LotUseDate",
				LotVialNumber = "LotVialNumber",
				RackGuid = "RackGuid",
				RackLotGuid = "RackLotGuid",
				ReactivityPhaseCode = "ReactivityPhaseCode",
				ReagentGuid = "ReagentGuid",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				SatisfactoryResultIndicator = "SatisfactoryResultIndicator",
				TestingMethodCode = "TestingMethodCode",
				TestWithId = "TestWithId",
				TestWithName = "TestWithName";
		}

		/// <summary>
		/// RackTest class
		/// </summary>
		public abstract class RackTest
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "RackTest",
				DivisionCode = "DivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RackLotGuid = "RackLotGuid",
				RackTestGuid = "RackTestGuid",
				RackTestResult = "RackTestResult",
				RackTestResultTypeCode = "RackTestResultTypeCode",
				ReagentAmount = "ReagentAmount",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				TestDate = "TestDate",
				TestTechId = "TestTechId",
				TestWithReagentGuid = "TestWithReagentGuid";
		}

		/// <summary>
		/// RackTestResultType class
		/// </summary>
		public abstract class RackTestResultType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "RackTestResultType",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RackTestResultTypeCode = "RackTestResultTypeCode",
				RackTestResultTypeText = "RackTestResultTypeText",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// ReactivityPhase class
		/// </summary>
		public abstract class ReactivityPhase
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ReactivityPhase",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				ReactivityPhaseCode = "ReactivityPhaseCode",
				ReactivityPhaseText = "ReactivityPhaseText",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// Reagent class
		/// </summary>
		public abstract class Reagent
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "Reagent",
				Comments = "Comments",
				DivisionCode = "DivisionCode",
				InspectionIndicator = "InspectionIndicator",
				InventoryChangeDate = "InventoryChangeDate",
				InvoiceNumber = "InvoiceNumber",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				LotExpirationDate = "LotExpirationDate",
				LotNumber = "LotNumber",
				NumberVialsAvailable = "NumberVialsAvailable",
				NumberVialsReceived = "NumberVialsReceived",
				ReagentGuid = "ReagentGuid",
				ReagentManufacturerName = "ReagentManufacturerName",
				ReagentName = "ReagentName",
				ReagentTypeId = "ReagentTypeId",
				ReceiptDate = "ReceiptDate",
				ReceiptTechId = "ReceiptTechId",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// ReagentChange class
		/// </summary>
		public abstract class ReagentChange
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ReagentChange",
				Comments = "Comments",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				ReagentChangeDetailCode = "ReagentChangeDetailCode",
				ReagentChangeGuid = "ReagentChangeGuid",
				ReagentGuid = "ReagentGuid",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// ReagentChangeDetail class
		/// </summary>
		public abstract class ReagentChangeDetail
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ReagentChangeDetail",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				ReagentChangeDetailCode = "ReagentChangeDetailCode",
				ReagentChangeDetailText = "ReagentChangeDetailText",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// ReagentTestParameter class
		/// </summary>
		public abstract class ReagentTestParameter
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ReagentTestParameter",
				CanChangeIndicator = "CanChangeIndicator",
				CommercialIndicator = "CommercialIndicator",
				DailyUseIndicator = "DailyUseIndicator",
				DivisionCode = "DivisionCode",
				ExpectedMinimumReactions = "ExpectedMinimumReactions",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MustUseIndicator = "MustUseIndicator",
				ReactivityPhaseCode = "ReactivityPhaseCode",
				ReagentTestParameterGuid = "ReagentTestParameterGuid",
				ReagentTypeId = "ReagentTypeId",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				SetVialId = "SetVialId",
				SortColumn = "SortColumn",
				TestWithId = "TestWithId",
				TestWithName = "TestWithName";
		}

		/// <summary>
		/// ReagentType class
		/// </summary>
		public abstract class ReagentType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ReagentType",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MustUseIndicator = "MustUseIndicator",
				ReactivityPhaseCode = "ReactivityPhaseCode",
				ReagentTypeId = "ReagentTypeId",
				ReagentTypeName = "ReagentTypeName",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// ReagentTypeParameter class
		/// </summary>
		public abstract class ReagentTypeParameter
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ReagentTypeParameter",
				DivisionCode = "DivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MinimumStockLevel = "MinimumStockLevel",
				ReagentTypeId = "ReagentTypeId",
				ReagentTypeParameterGuid = "ReagentTypeParameterGuid",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// RecordStatus class
		/// </summary>
		public abstract class RecordStatus
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "RecordStatus",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RecordStatusCode = "RecordStatusCode",
				RecordStatusText = "RecordStatusText",
				RowVersion = "RowVersion";
		}

		/// <summary>
		/// ReOrderTest class
		/// </summary>
		public abstract class ReOrderTest
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ReOrderTest",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OrderableTestId = "OrderableTestId",
				ReOrderTestId = "ReOrderTestId",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// ReportType class
		/// </summary>
		public abstract class ReportType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ReportType",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				ReportTypeId = "ReportTypeId",
				ReportTypeName = "ReportTypeName",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// RestrictionType class
		/// </summary>
		public abstract class RestrictionType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "RestrictionType",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RestrictionTypeCode = "RestrictionTypeCode",
				RestrictionTypeText = "RestrictionTypeText",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// RhFactor class
		/// </summary>
		public abstract class RhFactor
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "RhFactor",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RhFactorCode = "RhFactorCode",
				RhFactorText = "RhFactorText",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// RoleFunction class
		/// </summary>
		public abstract class RoleFunction
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "RoleFunction",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RoleFunctionId = "RoleFunctionId",
				RoleFunctionText = "RoleFunctionText",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// ScanBloodType class
		/// </summary>
		public abstract class ScanBloodType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ScanBloodType",
				BloodTypeCode = "BloodTypeCode",
				DigiTraxCode = "DigiTraxCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RhFactorCode = "RhFactorCode",
				RowVersion = "RowVersion",
				ScanBloodTypeCode = "ScanBloodTypeCode",
				ScanBloodTypeText = "ScanBloodTypeText",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// ScheduledReport class
		/// </summary>
		public abstract class ScheduledReport
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ScheduledReport",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				ReportParameters = "ReportParameters",
				ReportPrintDate = "ReportPrintDate",
				RowVersion = "RowVersion",
				ScheduledReportGuid = "ScheduledReportGuid",
				TaskStatusCode = "TaskStatusCode";
		}

		/// <summary>
		/// Shipment class
		/// </summary>
		public abstract class Shipment
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "Shipment",
				DivisionCode = "DivisionCode",
				InvoiceNumber = "InvoiceNumber",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				LocalSupplierGuid = "LocalSupplierGuid",
				ProductShipperGuid = "ProductShipperGuid",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				ShipmentDate = "ShipmentDate",
				ShipmentDirection = "ShipmentDirection",
				ShipmentGuid = "ShipmentGuid",
				ShipmentTemperature = "ShipmentTemperature",
				ShipmentTypeCode = "ShipmentTypeCode";
		}

		/// <summary>
		/// ShipmentType class
		/// </summary>
		public abstract class ShipmentType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ShipmentType",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				ShipmentTypeCode = "ShipmentTypeCode",
				ShipmentTypeText = "ShipmentTypeText",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// SpecimenStatus class
		/// </summary>
		public abstract class SpecimenStatus
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "SpecimenStatus",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				SpecimenStatusCode = "SpecimenStatusCode",
				SpecimenStatusText = "SpecimenStatusText";
		}

		/// <summary>
		/// SpecimenTest class
		/// </summary>
		public abstract class SpecimenTest
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "SpecimenTest",
				AboRhChangeIndicator = "AboRhChangeIndicator",
				AboRhChangeJustification = "AboRhChangeJustification",
				AntibodyTypeId = "AntibodyTypeId",
				AutoInstrumentName = "AutoInstrumentName",
				AutoInstrumentQCIndicator = "AutoInstrumentQCIndicator",
				BloodTestTypeId = "BloodTestTypeId",
				CannedCommentGuid = "CannedCommentGuid",
				CorrectedResultIndicator = "CorrectedResultIndicator",
				DivisionCode = "DivisionCode",
				EntryTechId = "EntryTechId",
				InactivateDate = "InactivateDate",
				InactivateUser = "InactivateUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				OffsiteCost = "OffsiteCost",
				OffsiteIndicator = "OffsiteIndicator",
				OffsiteLocation = "OffsiteLocation",
				OrderedTestGuid = "OrderedTestGuid",
				PatientSpecimenGuid = "PatientSpecimenGuid",
				PatientTransfusionReactionGuid = "PatientTransfusionReactionGuid",
				RackGuid = "RackGuid",
				ReactivityPhaseCode = "ReactivityPhaseCode",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				SpecimenTestGuid = "SpecimenTestGuid",
				TestComments = "TestComments",
				TestDate = "TestDate",
				TestingMethodCode = "TestingMethodCode",
				TestResultId = "TestResultId",
				TestTechId = "TestTechId";
		}

		/// <summary>
		/// SpecimenTestThreshold class
		/// </summary>
		public abstract class SpecimenTestThreshold
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "SpecimenTestThreshold",
				ComponentClassId = "ComponentClassId",
				DivisionCode = "DivisionCode",
				LabTestId = "LabTestId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RecordStatusCode = "RecordStatusCode",
				ReportTypeId = "ReportTypeId",
				RowVersion = "RowVersion",
				SpecimenTestThresholdGuid = "SpecimenTestThresholdGuid",
				SpecimenTypeCode = "SpecimenTypeCode",
				ThresholdResult = "ThresholdResult",
				VistaLaboratoryTestName = "VistaLaboratoryTestName",
				WorkloadCode = "WorkloadCode";
		}

		/// <summary>
		/// SpecimenType class
		/// </summary>
		public abstract class SpecimenType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "SpecimenType",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				SpecimenTypeCode = "SpecimenTypeCode",
				SpecimenTypeText = "SpecimenTypeText";
		}

		/// <summary>
		/// State class
		/// </summary>
		public abstract class State
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "State",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				StateCode = "StateCode",
				StateName = "StateName";
		}

		/// <summary>
		/// Supply class
		/// </summary>
		public abstract class Supply
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "Supply",
				AvailableQuantity = "AvailableQuantity",
				Comments = "Comments",
				DivisionCode = "DivisionCode",
				InventoryChangeDate = "InventoryChangeDate",
				InvoiceNumber = "InvoiceNumber",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				LotExpirationDate = "LotExpirationDate",
				LotNumber = "LotNumber",
				LotQuantity = "LotQuantity",
				ManufacturerName = "ManufacturerName",
				ReceiptDate = "ReceiptDate",
				ReceiptTechId = "ReceiptTechId",
				RowVersion = "RowVersion",
				SatisfactoryIndicator = "SatisfactoryIndicator",
				SupplyGuid = "SupplyGuid",
				SupplyName = "SupplyName",
				SupplyTypeId = "SupplyTypeId";
		}

		/// <summary>
		/// SupplyType class
		/// </summary>
		public abstract class SupplyType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "SupplyType",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				SupplyTypeId = "SupplyTypeId",
				SupplyTypeText = "SupplyTypeText";
		}

		/// <summary>
		/// TaskStatus class
		/// </summary>
		public abstract class TaskStatus
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "TaskStatus",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				TaskStatusCode = "TaskStatusCode",
				TaskStatusText = "TaskStatusText";
		}

		/// <summary>
		/// TestingMethod class
		/// </summary>
		public abstract class TestingMethod
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "TestingMethod",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				TestingMethodCode = "TestingMethodCode",
				TestingMethodText = "TestingMethodText";
		}

		/// <summary>
		/// TestingStatus class
		/// </summary>
		public abstract class TestingStatus
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "TestingStatus",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				TestingStatusCode = "TestingStatusCode",
				TestingStatusId = "TestingStatusId",
				TestingStatusText = "TestingStatusText";
		}

		/// <summary>
		/// TestResult class
		/// </summary>
		public abstract class TestResult
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "TestResult",
				CanChangeIndicator = "CanChangeIndicator",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				TestResultId = "TestResultId",
				TestResultText = "TestResultText";
		}

		/// <summary>
		/// TimeZone class
		/// </summary>
		public abstract class TimeZone
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "TimeZone",
				DaylightTimeName = "DaylightTimeName",
				DaylightTimeText = "DaylightTimeText",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				StandardTimeText = "StandardTimeText",
				TimeZoneBias = "TimeZoneBias",
				TimeZoneId = "TimeZoneId",
				TimeZoneName = "TimeZoneName";
		}

		/// <summary>
		/// tmplAntibodyParameter class
		/// </summary>
		public abstract class tmplAntibodyParameter
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "tmplAntibodyParameter",
				AntibodyParameterGuid = "AntibodyParameterGuid",
				AntibodyTypeId = "AntibodyTypeId",
				CanChangeIndicator = "CanChangeIndicator",
				CompatibilityPercentage = "CompatibilityPercentage",
				HigherLevelOverrideIndicator = "HigherLevelOverrideIndicator";
		}

		/// <summary>
		/// tmplCannedComment class
		/// </summary>
		public abstract class tmplCannedComment
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "tmplCannedComment",
				CannedCommentCategoryCode = "CannedCommentCategoryCode",
				CannedCommentGuid = "CannedCommentGuid",
				CannedCommentText = "CannedCommentText",
				RecordStatusCode = "RecordStatusCode",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// tmplComponentClassParameter class
		/// </summary>
		public abstract class tmplComponentClassParameter
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "tmplComponentClassParameter",
				ComponentClassId = "ComponentClassId",
				ComponentClassParameterGuid = "ComponentClassParameterGuid",
				MaximumTransfusionTime = "MaximumTransfusionTime",
				OrderableIndicator = "OrderableIndicator",
				RecordStatusCode = "RecordStatusCode",
				SpecimenRequiredIndicator = "SpecimenRequiredIndicator";
		}

		/// <summary>
		/// tmplMsbos class
		/// </summary>
		public abstract class tmplMsbos
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "tmplMsbos",
				MsbosGuid = "MsbosGuid",
				RecordStatusCode = "RecordStatusCode",
				SurgeryName = "SurgeryName",
				TypeAndScreenIndicator = "TypeAndScreenIndicator";
		}

		/// <summary>
		/// tmplProductModificationParameter class
		/// </summary>
		public abstract class tmplProductModificationParameter
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "tmplProductModificationParameter",
				ProductModificationCode = "ProductModificationCode",
				ProductModificationCost = "ProductModificationCost",
				ProductModificationParameterGuid = "ProductModificationParameterGuid",
				RecordStatusCode = "RecordStatusCode";
		}

		/// <summary>
		/// tmplRack class
		/// </summary>
		public abstract class tmplRack
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "tmplRack",
				RackGuid = "RackGuid",
				RackName = "RackName",
				RecordStatusCode = "RecordStatusCode",
				SortColumn = "SortColumn";
		}

		/// <summary>
		/// tmplReagentTestParameter class
		/// </summary>
		public abstract class tmplReagentTestParameter
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "tmplReagentTestParameter",
				CanChangeIndicator = "CanChangeIndicator",
				CommercialIndicator = "CommercialIndicator",
				DailyUseIndicator = "DailyUseIndicator",
				ExpectedMinimumReactions = "ExpectedMinimumReactions",
				MustUseIndicator = "MustUseIndicator",
				ReactivityPhaseCode = "ReactivityPhaseCode",
				ReagentTestParameterGuid = "ReagentTestParameterGuid",
				ReagentTypeId = "ReagentTypeId",
				RecordStatusCode = "RecordStatusCode",
				SetVialId = "SetVialId",
				SortColumn = "SortColumn",
				TestWithId = "TestWithId",
				TestWithName = "TestWithName";
		}

		/// <summary>
		/// tmplVbecsUser class
		/// </summary>
		public abstract class tmplVbecsUser
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "tmplVbecsUser",
				RecordStatusCode = "RecordStatusCode",
				SystemUserIndicator = "SystemUserIndicator",
				UserDUZ = "UserDUZ",
				UserEmail = "UserEmail",
				UserInitials = "UserInitials",
				UserName = "UserName",
				VbecsUserGuid = "VbecsUserGuid",
				VbecsUserId = "VbecsUserId",
				VistaUserName = "VistaUserName";
		}

		/// <summary>
		/// tmplVbecsUserDivisionRole class
		/// </summary>
		public abstract class tmplVbecsUserDivisionRole
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "tmplVbecsUserDivisionRole",
				RecordStatusCode = "RecordStatusCode",
				UserRoleId = "UserRoleId",
				VbecsUserId = "VbecsUserId";
		}

		/// <summary>
		/// TransfusionReaction class
		/// </summary>
		public abstract class TransfusionReaction
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "TransfusionReaction",
				BagClericalChecksOkIndicator = "BagClericalChecksOkIndicator",
				BagHemolysisInspectionCode = "BagHemolysisInspectionCode",
				BagReturnedIndicator = "BagReturnedIndicator",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				PatientTransfusionGuid = "PatientTransfusionGuid",
				PatientTransfusionReactionGuid = "PatientTransfusionReactionGuid",
				PostClericalChecksOkIndicator = "PostClericalChecksOkIndicator",
				PreClericalChecksOkIndicator = "PreClericalChecksOkIndicator",
				RowVersion = "RowVersion",
				TagNotScannedIndicator = "TagNotScannedIndicator",
				TransfusionReactionGuid = "TransfusionReactionGuid";
		}

		/// <summary>
		/// TransfusionReactionType class
		/// </summary>
		public abstract class TransfusionReactionType
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "TransfusionReactionType",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				TransfusionReactionTypeCode = "TransfusionReactionTypeCode",
				TransfusionReactionTypeText = "TransfusionReactionTypeText";
		}

		/// <summary>
		/// TransfusionRequirementCategory class
		/// </summary>
		public abstract class TransfusionRequirementCategory
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "TransfusionRequirementCategory",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				TransfusionRequirementCategoryCode = "TransfusionRequirementCategoryCode",
				TransfusionRequirementCategoryText = "TransfusionRequirementCategoryText";
		}

		/// <summary>
		/// TreatingSpecialty class
		/// </summary>
		public abstract class TreatingSpecialty
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "TreatingSpecialty",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				TreatingSpecialtyCode = "TreatingSpecialtyCode",
				TreatingSpecialtyName = "TreatingSpecialtyName";
		}

		/// <summary>
		/// UnitStatus class
		/// </summary>
		public abstract class UnitStatus
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "UnitStatus",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				UnitStatusCode = "UnitStatusCode",
				UnitStatusText = "UnitStatusText";
		}

		/// <summary>
		/// UserRole class
		/// </summary>
		public abstract class UserRole
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "UserRole",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				UserRoleId = "UserRoleId",
				UserRoleName = "UserRoleName";
		}

		/// <summary>
		/// UserRoleFunction class
		/// </summary>
		public abstract class UserRoleFunction
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "UserRoleFunction",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RoleFunctionId = "RoleFunctionId",
				RowVersion = "RowVersion",
				UserRoleId = "UserRoleId";
		}

		/// <summary>
		/// ValidAboResult class
		/// </summary>
		public abstract class ValidAboResult
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ValidAboResult",
				AboInitial = "ABOInitial",
				AboInterp = "ABOInterp",
				AntiA = "AntiA",
				AntiAB = "AntiAB",
				AntiB = "AntiB",
				ResultId = "ResultId";
		}

		/// <summary>
		/// ValidRhResult class
		/// </summary>
		public abstract class ValidRhResult
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "ValidRhResult",
				AntiD = "AntiD",
				DControl = "DControl",
				ResultId = "ResultId",
				RhInitial = "RhInitial",
				RhInterp = "RhInterp",
				SystemInterp = "SystemInterp";
		}

		/// <summary>
		/// VamcDivision class
		/// </summary>
		public abstract class VamcDivision
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "VamcDivision",
				AccessionAreaId = "AccessionAreaId",
				AntibodyScreenDisplayCode = "AntibodyScreenDisplayCode",
				AutomatedInstrumentIndicator = "AutomatedInstrumentIndicator",
				DaylightSavingsEndDate = "DaylightSavingsEndDate",
				DaylightSavingsStartDate = "DaylightSavingsStartDate",
				DaylightSavingsTypeId = "DaylightSavingsTypeId",
				DivisionCode = "DivisionCode",
				DivisionGuid = "DivisionGuid",
				DivisionName = "DivisionName",
				ElectronicCrossmatchIndicator = "ElectronicCrossmatchIndicator",
				FacilityGuid = "FacilityGuid",
				IccbbaRegistrationNumber = "IccbbaRegistrationNumber",
				IconAlertsIndicator = "IconAlertsIndicator",
				IconOrderAlertTypeCode = "IconOrderAlertTypeCode",
				IconOrdersNeededHours = "IconOrdersNeededHours",
				IconRefreshRate = "IconRefreshRate",
				InvoiceTemplateText = "InvoiceTemplateText",
				LabelPrinterComPortNumber = "LabelPrinterComPortNumber",
				LabelPrinterIPAddress = "LabelPrinterIPAddress",
				LabelPrinterTcpPortNumber = "LabelPrinterTcpPortNumber",
				LabelPrinterUseIndicator = "LabelPrinterUseIndicator",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				LocalSupplierGuid = "LocalSupplierGuid",
				LockInactivityTimeoutMin = "LockInactivityTimeoutMin",
				LoginMessageText = "LoginMessageText",
				MaximumSpecimenExpirationDays = "MaximumSpecimenExpirationDays",
				MedicalDirectorName = "MedicalDirectorName",
				PrinterAlertsIndicator = "PrinterAlertsIndicator",
				PrinterAlertsPrinterName = "PrinterAlertsPrinterName",
				PrinterName = "PrinterName",
				PrinterOrderAlertTypeCode = "PrinterOrderAlertTypeCode",
				PrinterOrdersNeededHours = "PrinterOrdersNeededHours",
				ReactivityPhaseCode = "ReactivityPhaseCode",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				ServiceTypeIndicator = "ServiceTypeIndicator",
				TimeZoneId = "TimeZoneId",
				UsaIndicator = "UsaIndicator";
		}

        /// <summary>
        /// VbecsGlobalConfig class
        /// </summary>
        public abstract class VbecsGlobalConfig
        {
            /// <summary>
            /// Table name and list of all columns on that table written as const
            /// </summary>
            public const string
                TableName = "VbecsGlobalConfig",
                ApplicationName = "ApplicationName",
                ParameterName = "ParameterName",
                ParameterValue = "ParameterValue",
                LastUpdateDate = "LastUpdateDate",
                LastUpdateFunctionId = "LastUpdateFunctionId",
                LastUpdateUser = "LastUpdateUser",
                RowVersion = "RowVersion";
        }

		/// <summary>
		/// VbecsLock class
		/// </summary>
		public abstract class VbecsLock
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "VbecsLock",
                BaseLockedFormId = "BaseLockedFormId",
				DivisionCode = "DivisionCode",
                LockedFormId = "LockedFormId",
                LockedUseCaseId = "LockedUseCaseId",
				LockFunctionId = "LockFunctionId",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MultiDivisionIndicator = "MultiDivisionIndicator",
				LockedRecordGuid = "LockedRecordGuid",
				RowVersion = "RowVersion",
				SessionGuid = "SessionGuid",
                VbecsLockId = "VbecsLockId";
		}

		/// <summary>
		/// VbecsLockFunction class
		/// </summary>
		public abstract class VbecsLockFunction
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "VbecsLockFunction",
				FunctionDescription = "FunctionDescription",
				FunctionName = "FunctionName",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				VbecsFunctionId = "VbecsFunctionId";
		}

		/// <summary>
		/// VbecsOrder class
		/// </summary>
		public abstract class VbecsOrder
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "VbecsOrder",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				VbecsOrderNumber = "VbecsOrderNumber";
		}

		/// <summary>
		/// VbecsProcess class
		/// </summary>
		public abstract class VbecsProcess
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "VbecsProcess",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				TransactionType = "TransactionType",
				VbecsProcessGuid = "VbecsProcessGuid",
				VbecsProcessId = "VbecsProcessId",
				VbecsProcessName = "VbecsProcessName";
		}

		/// <summary>
		/// VbecsUser class
		/// </summary>
		public abstract class VbecsUser
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "VbecsUser",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				SystemUserIndicator = "SystemUserIndicator",
				UserDUZ = "UserDUZ",
				UserEmail = "UserEmail",
				UserInitials = "UserInitials",
				UserName = "UserName",
				VbecsUserGuid = "VbecsUserGuid",
				VbecsUserId = "VbecsUserId",
				VistaUserName = "VistaUserName";
		}

		/// <summary>
		/// VbecsUserDivisionRole class
		/// </summary>
		public abstract class VbecsUserDivisionRole
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "VbecsUserDivisionRole",
				DivisionCode = "DivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				UserRoleId = "UserRoleId",
				VbecsUserId = "VbecsUserId";
		}

		/// <summary>
		/// VbecsVersion class
		/// </summary>
		public abstract class VbecsVersion
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "VbecsVersion",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				PatchSuccessfulIndicator = "PatchSuccessfulIndicator",
				RowVersion = "RowVersion",
				VbecsVersionId = "VbecsVersionId",
				Version = "Version";
		}
        /// <summary>
        /// VbecsDBRevision class CR 3453
        /// </summary>
        public abstract class VbecsDBRevision
        {
            /// <summary>
            /// Table name and list of all columns on that table written as const
            /// </summary>
            public const string
                TableName = "VbecsDBRevision",
                LastUpdateDate = "LastUpdateDate",
                LastUpdateUser = "LastUpdateUser",
                Revision = "Revision",
                Comment = "Comment",
                VbecsVersion = "VbecsVersion";
        }

		/// <summary>
		/// VistaCache class
		/// </summary>
		public abstract class VistaCache
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "VistaCache",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				VistaDataSetName = "VistaDataSetName",
				VistaXml = "VistaXml";
		}

		/// <summary>
		/// VistaLinkControl class
		/// </summary>
		public abstract class VistaLinkControl
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "VistaLinkControl",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				ServerAlias = "ServerAlias",
				ServerAppHandle = "ServerAppHandle",
                VbecsServiceIpAddress = "VbecsServiceIpAddress",
                VbecsServicePortNumber = "VbecsServicePortNumber",
				VistaDomainName = "VistaDomainName",
				VistaIpAddress = "VistaIpAddress",
				VistaPortNumber = "VistaPortNumber";
		}

		/// <summary>
		/// WorkloadCache class
		/// </summary>
		public abstract class WorkloadCache
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "WorkloadCache",
				Code_Id = "Code_Id",
				Cost = "Cost",
				LastUpdateDate = "LastUpdateDate",
				Lmip = "Lmip",
				Procedure = "Procedure",
				WeightMultiplier = "WeightMultiplier";
		}

		/// <summary>
		/// WorkloadEvent class
		/// </summary>
		public abstract class WorkloadEvent
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "WorkloadEvent",
				BloodUnitGuid = "BloodUnitGuid",
				DivisionCode = "DivisionCode",
				ErrorText = "ErrorText",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				MiscellaneousGuid = "MiscellaneousGuid",
				OrderedComponentGuid = "OrderedComponentGuid",
				OrderedTestGuid = "OrderedTestGuid",
				PatientGuid = "PatientGuid",
				PceEncounterNumber = "PceEncounterNumber",
				ProcessedDate = "ProcessedDate",
				RecordSentIndicator = "RecordSentIndicator",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				VistaTechId = "VistaTechId",
				WeightMultiplier = "WeightMultiplier",
				WorkloadEventDate = "WorkloadEventDate",
				WorkloadEventGuid = "WorkloadEventGuid",
				WorkloadEventStatusCode = "WorkloadEventStatusCode",
				WorkloadProcessGuid = "WorkloadProcessGuid";
		}

		/// <summary>
		/// WorkloadEventStatus class
		/// </summary>
		public abstract class WorkloadEventStatus
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "WorkloadEventStatus",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RowVersion = "RowVersion",
				SortColumn = "SortColumn",
				WorkloadEventStatusCode = "WorkloadEventStatusCode",
				WorkloadEventStatusText = "WorkloadEventStatusText";
		}

		/// <summary>
		/// WorkloadProcess class
		/// </summary>
		public abstract class WorkloadProcess
		{
			/// <summary>
			/// Table name and list of all columns on that table written as const
			/// </summary>
			public const string
				TableName = "WorkloadProcess",
				AssignedDate = "AssignedDate",
				DivisionCode = "DivisionCode",
				LastUpdateDate = "LastUpdateDate",
				LastUpdateFunctionId = "LastUpdateFunctionId",
				LastUpdateUser = "LastUpdateUser",
				RecordStatusCode = "RecordStatusCode",
				RowVersion = "RowVersion",
				UnAssignedDate = "UnAssignedDate",
				VbecsProcessId = "VbecsProcessId",
				WeightMultiplier = "WeightMultiplier",
				WorkloadCode = "WorkloadCode",
				WorkloadProcedure = "WorkloadProcedure",
				WorkloadProcessGuid = "WorkloadProcessGuid";
		}
        /// <summary>
        /// PendingBloodUnitTest
        /// </summary>
        public abstract class PendingBloodUnitTest
        {
            /// <summary>
            /// List of all parms written as const
            /// </summary>
            public const string
                TableName = "PendingBloodUnitTest",
                PendingBloodUnitTestId = "PendingBloodUnitTestId",
                BloodUnitTestGuid = "BloodUnitTestGuid",
                BloodUnitGuid = "BloodUnitGuid",
                BloodTestTypeId = "BloodTestTypeId",
                BloodUnitId = "BloodUnitId",
                TestDate = "TestDate",
                TestTechId = "TestTechId",
                TestResultId = "TestResultId",
                AutoInstrumentComments = "AutoInstrumentComments",
                OrderedTestGuid = "OrderedTestGuid",
                OrderedComponentGuid = "OrderedComponentGuid",
                AutoInstrumentName = "AutoInstrumentName",
                DivisionCode = "DivisionCode",
                PendingTestStatusId = "PendingTestStatusId",
                RejectionComment = "RejectionComment",
                UnitResultSetGuid = "UnitResultSetGuid",
                OrderedUnitGuid = "OrderedUnitGuid",
                LastUpdateDate = "LastUpdateDate",
                LastUpdateUser = "LastUpdateUser",
                RowVersion = "RowVersion",
                LastUpdateFunctionId = "LastUpdateFunctionId";
         }


        /// <summary>
        /// PendingSpecimenTest
        /// </summary>
        public abstract class PendingSpecimenTest
        {
            /// <summary>
            /// List of all parms written as const
            /// </summary>
            public const string
                TableName = "PendingSpecimenTest",
                PendingSpecimenTestId = "PendingSpecimenTestId",
                SpecimenTestGuid = "SpecimenTestGuid",
                OrderedTestGuid = "OrderedTestGuid",
                PatientSpecimenGuid = "PatientSpecimenGuid",
                BloodTestTypeId = "BloodTestTypeId",
                TestDate = "TestDate",
                TestTechId = "TestTechId",
                TestResultId = "TestResultId",
                AutoInstrumentName = "AutoInstrumentName",
                AutoInstrumentComments = "AutoInstrumentComments",
                DivisionCode = "DivisionCode",
                PendingTestStatusId = "PendingTestStatusId",
                RejectionComment = "RejectionComment",
                SpecimenResultSetGuid = "SpecimenResultSetGuid",
                LastUpdateDate = "LastUpdateDate",
                LastUpdateUser = "LastUpdateUser",
                RowVersion = "RowVersion",
                LastUpdateFunctionId = "LastUpdateFunctionId";
        }

        /// <summary>
        /// BloodTestTypeMapping
        /// </summary>
        public abstract class BloodTestTypeMapping
        {
            /// <summary>
            /// List of all parms written as const
            /// </summary>
            public const string
                BloodTestTypeMappingId = "BloodTestTypeMappingId",
                BloodTestTypeId = "BloodTestTypeId",
                BloodTestName = "BloodTestName",
                AntigenTestTypeId = "AntigenTestTypeId",
                LastUpdateDate = "LastUpdateDate",
                LastUpdateUser = "LastUpdateUser",
                RowVersion = "RowVersion",
                LastUpdateFunctionId = "LastUpdateFunctionId";
        }
 


	}
}